/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.verifications.text.ui;

import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.list.IListChangeListener;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.ListChangeEvent;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.launching.AutLaunch;
import org.eclipse.rcptt.tesla.core.ui.StyleRangeEntry;
import org.eclipse.rcptt.ui.controls.SectionWithComposite;
import org.eclipse.rcptt.ui.editors.EditorHeader;
import org.eclipse.rcptt.ui.utils.RangeUtils;
import org.eclipse.rcptt.ui.verification.WidgetVerificationEditor;
import org.eclipse.rcptt.verifications.text.TextFactory;
import org.eclipse.rcptt.verifications.text.TextPackage;
import org.eclipse.rcptt.verifications.text.TextVerification;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class TextVerificationEditor
extends WidgetVerificationEditor {
    public TextVerification getVerification() {
        try {
            return (TextVerification)super.getElement().getNamedElement();
        }
        catch (ModelException e) {
            Q7UIPlugin.log((Throwable)e);
            return null;
        }
    }

    public void dispose() {
        super.dispose();
    }

    public Control create(Composite parent, FormToolkit toolkit, IWorkbenchSite site, EditorHeader header) {
        Section section = new SectionWithComposite("Widget Text", 322).create(parent, toolkit);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)section);
        Composite client = (Composite)section.getClient();
        GridLayoutFactory.fillDefaults().numColumns(1).spacing(-1, 16).applyTo(client);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)client);
        this.createWidgetControls(client, toolkit, site, header);
        Composite box = toolkit.createComposite(client);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)box);
        GridLayoutFactory.fillDefaults().numColumns(1).applyTo(box);
        this.createControls(toolkit, box);
        return section;
    }

    private void createControls(FormToolkit toolkit, Composite client) {
        Label introLabel = toolkit.createLabel(client, "Text should be:");
        introLabel.setForeground(toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE"));
        introLabel.setBackground(null);
        final StyledText text = new StyledText(client, 2818);
        text.setFont(JFaceResources.getTextFont());
        GridDataFactory.fillDefaults().grab(true, true).hint(1, 1).applyTo((Control)text);
        final Button ignoreStylingCheckbox = toolkit.createButton(client, "Ignore text styling and colors", 32);
        this.dbc.bindValue((IObservableValue)SWTObservables.observeText((Control)text, (int)24), EMFObservables.observeValue((EObject)this.getVerification(), (EStructuralFeature)TextPackage.Literals.TEXT_VERIFICATION__TEXT));
        IObservableList observableStyles = EMFObservables.observeList((EObject)this.getVerification(), (EStructuralFeature)TextPackage.Literals.TEXT_VERIFICATION__STYLES);
        observableStyles.addListChangeListener(new IListChangeListener(){

            public void handleListChange(ListChangeEvent event) {
                TextVerificationEditor.this.updateStyling(text, ignoreStylingCheckbox);
            }
        });
        Binding binding = this.dbc.bindValue((IObservableValue)SWTObservables.observeSelection((Control)ignoreStylingCheckbox), EMFObservables.observeValue((EObject)this.getVerification(), (EStructuralFeature)TextPackage.Literals.TEXT_VERIFICATION__IGNORE_STYLING));
        binding.getModel().addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                TextVerificationEditor.this.updateStyling(text, ignoreStylingCheckbox);
            }
        });
        this.updateStyling(text, ignoreStylingCheckbox);
    }

    public void setSelectionAtLine(int line) {
    }

    private void updateStyling(StyledText text, Button ignoreStylingCheckbox) {
        EList styles = this.getVerification().getStyles();
        boolean noStyling = styles.size() == 0 || this.getVerification().isIgnoreStyling();
        ignoreStylingCheckbox.setEnabled(styles.size() > 0);
        text.setStyleRange(null);
        text.setEditable(noStyling);
        if (noStyling) {
            return;
        }
        StyleRange[] ranges = new StyleRange[styles.size()];
        int i = 0;
        while (i < styles.size()) {
            ranges[i] = RangeUtils.fromEMF((StyleRangeEntry)((StyleRangeEntry)styles.get(i)), (Device)text.getDisplay());
            ++i;
        }
        text.setStyleRanges(ranges);
    }

    public EObject getCreateParam(AutLaunch launch) {
        TextVerification param = TextFactory.eINSTANCE.createTextVerification();
        param.setSelector(this.getVerification().getSelector());
        param.setIgnoreStyling(this.getVerification().isIgnoreStyling());
        return param;
    }
}

