/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.launching.launcher.BundleLauncherHelper;
import org.eclipse.pde.internal.launching.launcher.LaunchValidationOperation;
import org.eclipse.pde.internal.launching.launcher.OSGiValidationOperation;
import org.eclipse.pde.internal.ui.launcher.AbstractPluginBlock;
import org.eclipse.pde.ui.launcher.BundlesTab;

public class OSGiBundleBlock
extends AbstractPluginBlock {
    private ILaunchConfiguration fLaunchConfiguration;

    public OSGiBundleBlock(BundlesTab tab) {
        super(tab);
    }

    @Override
    protected void savePluginState(ILaunchConfigurationWorkingCopy config) {
        Object[] selected = this.fPluginTreeViewer.getCheckedLeafElements();
        AbstractPluginBlock.PluginModelNameBuffer wBuffer = new AbstractPluginBlock.PluginModelNameBuffer(this);
        AbstractPluginBlock.PluginModelNameBuffer tBuffer = new AbstractPluginBlock.PluginModelNameBuffer(this);
        Object[] objectArray = selected;
        int n = selected.length;
        int n2 = 0;
        while (n2 < n) {
            Object selectedElement = objectArray[n2];
            if (selectedElement instanceof IPluginModelBase) {
                IPluginModelBase model = (IPluginModelBase)selectedElement;
                if (model.getUnderlyingResource() == null) {
                    tBuffer.add(model);
                } else {
                    wBuffer.add(model);
                }
            }
            ++n2;
        }
        config.setAttribute("selected_workspace_bundles", wBuffer.getNameSet());
        config.setAttribute("selected_target_bundles", tBuffer.getNameSet());
        AbstractPluginBlock.PluginModelNameBuffer buffer = new AbstractPluginBlock.PluginModelNameBuffer(this);
        if (this.fAddWorkspaceButton.getSelection()) {
            IPluginModelBase[] workspaceModels = this.getWorkspaceModels();
            int i = 0;
            while (i < workspaceModels.length) {
                if (!this.fPluginTreeViewer.isCheckedLeafElement(workspaceModels[i])) {
                    buffer.add(workspaceModels[i]);
                }
                ++i;
            }
        }
        config.setAttribute("deselected_workspace_bundles", buffer.getNameSet());
    }

    public void initializeFrom(ILaunchConfiguration configuration) throws CoreException {
        super.initializeFrom(configuration, true);
        this.initializePluginsState(configuration);
        this.fLaunchConfiguration = configuration;
    }

    private void initializePluginsState(ILaunchConfiguration configuration) throws CoreException {
        Map selected = BundleLauncherHelper.getAllSelectedPluginBundles((ILaunchConfiguration)configuration);
        this.initializePluginsState(selected);
    }

    @Override
    protected LaunchValidationOperation createValidationOperation() {
        return new OSGiValidationOperation(this.fLaunchConfiguration);
    }
}

