/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.statemachine.custom.parsers;

import java.util.Collections;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParser;
import org.eclipse.gmf.runtime.common.ui.services.parser.IParserEditStatus;
import org.eclipse.gmf.runtime.common.ui.services.parser.ParserEditStatus;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.emf.ui.services.parser.ISemanticParser;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.papyrus.infra.internationalization.common.utils.InternationalizationPreferencesUtils;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.parsers.Messages;
import org.eclipse.papyrus.uml.diagram.statemachine.custom.util.TriggerUtil;
import org.eclipse.papyrus.uml.internationalization.utils.utils.UMLLabelInternationalization;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.UMLPackage;

public class DeferrableTriggerParser
implements IParser,
ISemanticParser {
    private static final String EMPTY_STRING = "";
    private static final String SPACE_STRING = " ";

    public List<Trigger> getSemanticElementsBeingParsed(EObject element) {
        if (element instanceof Trigger) {
            Trigger trigger = (Trigger)element;
            return Collections.singletonList(trigger);
        }
        return Collections.emptyList();
    }

    public boolean areSemanticElementsAffected(EObject listener, Object notification) {
        return true;
    }

    public String getEditString(IAdaptable element, int flags) {
        Object obj = element.getAdapter(Behavior.class);
        if (obj instanceof Trigger) {
            Trigger trigger = (Trigger)obj;
            return UMLLabelInternationalization.getInstance().getLabel((NamedElement)trigger);
        }
        return EMPTY_STRING;
    }

    public IParserEditStatus isValidEditString(IAdaptable element, String editString) {
        return new ParserEditStatus("org.eclipse.papyrus.uml.diagram.statemachine", 0, EMPTY_STRING);
    }

    public ICommand getParseCommand(IAdaptable element, String newString, int flags) {
        AbstractTransactionalCommand cmd;
        final Trigger trigger = (Trigger)((EObjectAdapter)element).getRealObject();
        EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)trigger);
        final String newStringResult = newString;
        if (editingDomain != null && editingDomain instanceof TransactionalEditingDomain && (cmd = new AbstractTransactionalCommand((TransactionalEditingDomain)editingDomain, "Set new name in " + trigger.getName(), null){

            protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
                if (InternationalizationPreferencesUtils.getInternationalizationPreference((EObject)trigger) && UMLLabelInternationalization.getInstance().getLabelWithoutUML((NamedElement)trigger) != null) {
                    UMLLabelInternationalization.getInstance().setLabel((NamedElement)trigger, newStringResult, null);
                } else {
                    trigger.setName(newStringResult);
                }
                return CommandResult.newOKCommandResult();
            }
        }) != null && cmd.canExecute()) {
            return cmd;
        }
        return UnexecutableCommand.INSTANCE;
    }

    public String getPrintString(IAdaptable element, int flags) {
        Object obj = element.getAdapter(EObject.class);
        View view = (View)element.getAdapter(View.class);
        if (obj instanceof Trigger) {
            Trigger trigger = (Trigger)obj;
            StringBuilder result = new StringBuilder();
            if (trigger.getEvent() != null) {
                result.append(TriggerUtil.getTextForTrigger(view, trigger));
            }
            result.append(SPACE_STRING);
            result.append(Messages.DeferrableTriggerParser_DEFER_KEYWORD);
            return result.toString();
        }
        return EMPTY_STRING;
    }

    public boolean isAffectingEvent(Object event, int flags) {
        EStructuralFeature eStrucFeature;
        Object feature;
        int notificationType;
        return event instanceof Notification && (3 == (notificationType = ((Notification)event).getEventType()) || 1 == notificationType || 4 == notificationType) && (feature = ((Notification)event).getFeature()) instanceof EStructuralFeature && UMLPackage.Literals.STATE__DEFERRABLE_TRIGGER.equals(eStrucFeature = (EStructuralFeature)feature);
    }

    public IContentAssistProcessor getCompletionProcessor(IAdaptable element) {
        return null;
    }
}

