/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.handler;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.command.ILayerCommand;
import org.eclipse.papyrus.infra.nattable.applynamedstyle.PapyrusApplyNamedStyleCommand;
import org.eclipse.papyrus.infra.nattable.handler.AbstractTableHandler;
import org.eclipse.papyrus.infra.nattable.manager.table.INattableModelManager;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.IAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.AbstractAxisProvider;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.StyledElement;
import org.eclipse.papyrus.infra.nattable.utils.AxisUtils;

public class SetDisplayListOnSeparatedRowsHandler
extends AbstractTableHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        TransactionalEditingDomain editingDomain = this.getTableEditingDomain();
        INattableModelManager manager = this.getCurrentNattableModelManager();
        NatTable natTable = this.getCurrentNatTable();
        if (editingDomain != null && manager != null && natTable != null) {
            int selectedAxisIndex = AxisUtils.getUniqueSelectedAxisIndex(manager);
            AbstractAxisProvider axisProvider = manager.getTable().getCurrentColumnAxisProvider();
            if (axisProvider != null && selectedAxisIndex >= 0 && selectedAxisIndex < axisProvider.getAxis().size()) {
                IAxis selectedAxis = (IAxis)axisProvider.getAxis().get(selectedAxisIndex);
                natTable.doCommand((ILayerCommand)new PapyrusApplyNamedStyleCommand(editingDomain, (StyledElement)selectedAxis, "displayListOnSeparatedRows"));
            }
        }
        return null;
    }
}

