/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.emf.gmf.util;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.workspace.EMFCommandOperation;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.ICompositeCommand;
import org.eclipse.papyrus.infra.emf.gmf.command.INonDirtying;

public class CommandUtils {
    public static final Registry REGISTRY = new Registry();

    private CommandUtils() {
    }

    public static String getLabel(Object command) {
        return REGISTRY.getLabeller(command).apply(command);
    }

    public static boolean isCompound(Object command) {
        return REGISTRY.hasDecomposer(command);
    }

    public static <T, C extends T> Iterable<T> getChildren(C compoundCommand) {
        return REGISTRY.getDecomposer(compoundCommand).apply(compoundCommand);
    }

    public static <T> T chain(T command1, T command2) {
        return (T)REGISTRY.getComposer(command1).apply(command1, command2);
    }

    public static boolean isNonDirtying(Object command) {
        return command instanceof INonDirtying || command instanceof AbstractCommand.NonDirtying;
    }

    public static IUndoableOperation wrap(TransactionalEditingDomain domain, Command command) {
        if (command instanceof AbstractCommand.NonDirtying) {
            return new NonDirtyingEMFCommandOperation(domain, command);
        }
        return new EMFCommandOperation(domain, command);
    }

    public static IUndoableOperation wrap(TransactionalEditingDomain domain, Command command, Map<?, ?> options) {
        if (command instanceof AbstractCommand.NonDirtying) {
            return new NonDirtyingEMFCommandOperation(domain, command, options);
        }
        return new EMFCommandOperation(domain, command, options);
    }

    public static CompoundCommand nonDirtyingEMFCompound() {
        return new NonDirtyingEMFCompoundCommand();
    }

    public static Command chain(Command command1, Command command2) {
        if (command1 instanceof AbstractCommand.NonDirtying && command2 instanceof AbstractCommand.NonDirtying) {
            return new NonDirtyingEMFCompoundCommand().chain(command1).chain(command2);
        }
        return command1.chain(command2);
    }

    public static CompositeCommand nonDirtyingGMFComposite(String label) {
        return new NonDirtyingGMFCompositeCommand(label);
    }

    public static ICommand compose(ICommand command1, ICommand command2) {
        if (command1 instanceof INonDirtying && command2 instanceof INonDirtying) {
            return new NonDirtyingGMFCompositeCommand(command1.getLabel()).compose((IUndoableOperation)command1).compose((IUndoableOperation)command2);
        }
        return command1.compose((IUndoableOperation)command2);
    }

    private static class NonDirtyingEMFCommandOperation
    extends EMFCommandOperation
    implements INonDirtying {
        NonDirtyingEMFCommandOperation(TransactionalEditingDomain domain, Command command, Map<?, ?> options) {
            super(domain, NonDirtyingEMFCommandOperation.checkCommand(command), options);
        }

        NonDirtyingEMFCommandOperation(TransactionalEditingDomain domain, Command command) {
            super(domain, NonDirtyingEMFCommandOperation.checkCommand(command));
        }

        static Command checkCommand(Command command) {
            if (!(command instanceof AbstractCommand.NonDirtying)) {
                throw new IllegalStateException("Attempt to wrap dirtying command in a non-dirtying operation.");
            }
            return command;
        }
    }

    private static class NonDirtyingEMFCompoundCommand
    extends CompoundCommand
    implements AbstractCommand.NonDirtying {
        private NonDirtyingEMFCompoundCommand() {
        }

        public void append(Command command) {
            this.checkNonDirtying(command);
            super.append(command);
        }

        public boolean appendAndExecute(Command command) {
            this.checkNonDirtying(command);
            return super.appendAndExecute(command);
        }

        public boolean appendIfCanExecute(Command command) {
            this.checkNonDirtying(command);
            return super.appendIfCanExecute(command);
        }

        public Command chain(Command command) {
            this.append(command);
            return this;
        }

        private void checkNonDirtying(Command command) {
            if (!(command instanceof AbstractCommand.NonDirtying)) {
                throw new IllegalArgumentException("Attempt to append a dirtying command to a non-dirtying compound.");
            }
        }
    }

    private static class NonDirtyingGMFCompositeCommand
    extends CompositeCommand
    implements INonDirtying {
        NonDirtyingGMFCompositeCommand(String label) {
            super(label);
        }

        public void add(IUndoableOperation operation) {
            this.checkNonDirtying(operation);
            super.add(operation);
        }

        private void checkNonDirtying(IUndoableOperation operation) {
            if (!(operation instanceof INonDirtying)) {
                throw new IllegalArgumentException("Attempt to append a dirtying operation to a non-dirtying composite.");
            }
        }
    }

    public static class Registry {
        private final ConcurrentMap<Class<?>, BiFunction<?, ?, ?>> composers = new ConcurrentHashMap();
        private final ConcurrentMap<Class<?>, Function<?, ? extends Iterable<?>>> decomposers = new ConcurrentHashMap();
        private final ConcurrentMap<Class<?>, Function<?, String>> labellers = new ConcurrentHashMap();

        private Registry() {
            this.registerComposer(Command.class, CommandUtils::chain);
            this.registerDecomposer(CompoundCommand.class, CompoundCommand::getCommandList);
            this.registerLabeller(Command.class, Command::getLabel);
            this.registerComposer(ICommand.class, CommandUtils::compose);
            this.registerDecomposer(ICompositeCommand.class, c -> () -> c.iterator());
            this.registerLabeller(IUndoableOperation.class, IUndoableOperation::getLabel);
        }

        public <T, C extends T> void registerComposer(Class<T> commandType, BiFunction<? super T, ? super T, ? extends C> composer) {
            if (this.composers.putIfAbsent(commandType, composer) != null) {
                throw new IllegalStateException(String.format("Composer already registered for %s", commandType.getSimpleName()));
            }
        }

        public <T, C extends T> void registerDecomposer(Class<C> compoundType, Function<? super C, ? extends Iterable<? extends T>> decomposer) {
            if (this.decomposers.putIfAbsent(compoundType, decomposer) != null) {
                throw new IllegalStateException(String.format("Decomposer already registered for %s", compoundType.getSimpleName()));
            }
        }

        public <T> void registerLabeller(Class<T> commandType, Function<? super T, String> labeller) {
            if (this.labellers.putIfAbsent(commandType, labeller) != null) {
                throw new IllegalStateException(String.format("Labeller already registered for %s", commandType.getSimpleName()));
            }
        }

        <T, C extends T> BiFunction<T, T, C> getComposer(T command) {
            return this.composers.entrySet().stream().filter(e -> ((Class)e.getKey()).isInstance(command)).map(Map.Entry::getValue).findFirst().orElseThrow(IllegalArgumentException::new);
        }

        <T, C extends T> Function<? super C, ? extends Iterable<T>> getDecomposer(T command) {
            return this.maybeGetDecomposer(command).orElseThrow(IllegalArgumentException::new);
        }

        boolean hasDecomposer(Object command) {
            return this.maybeGetDecomposer(command).isPresent();
        }

        <T, C extends T> Optional<Function<? super C, ? extends Iterable<T>>> maybeGetDecomposer(C compound) {
            return this.decomposers.entrySet().stream().filter(e -> ((Class)e.getKey()).isInstance(compound)).map(Map.Entry::getValue).findFirst();
        }

        <T> Function<T, String> getLabeller(T command) {
            return this.labellers.entrySet().stream().filter(e -> ((Class)e.getKey()).isInstance(command)).map(Map.Entry::getValue).findFirst().orElse(Object::toString);
        }
    }
}

