/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.infra.browser.core;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.command.DragAndDropCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.modisco.infra.browser.Messages;
import org.eclipse.modisco.infra.browser.MoDiscoBrowserPlugin;
import org.eclipse.modisco.infra.browser.core.DragAndDropOnModelElementCommand;
import org.eclipse.modisco.infra.browser.core.QueryItem;
import org.eclipse.modisco.infra.browser.editors.BrowserConfiguration;
import org.eclipse.modisco.infra.browser.queries.SelectedQueriesManager;
import org.eclipse.modisco.infra.browser.queries.SelectedQuery;
import org.eclipse.modisco.infra.browser.uicore.internal.model.ITreeElement;
import org.eclipse.modisco.infra.browser.uicore.internal.model.LinkItem;
import org.eclipse.modisco.infra.browser.uicore.internal.model.ModelElementItem;
import org.eclipse.modisco.infra.browser.util.EditingSupportUtil;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;

public class ModelElementItemEx
extends ModelElementItem
implements IEditingDomainItemProvider {
    private final BrowserConfiguration browserConfiguration;

    public ModelElementItemEx(EObject eObject, ITreeElement treeParent, BrowserConfiguration browserConfiguration) {
        super(eObject, treeParent, browserConfiguration.getAppearanceConfiguration());
        this.browserConfiguration = browserConfiguration;
    }

    private void addSelectedQueries(List<Object> children) {
        SelectedQueriesManager selectedQueriesManager = this.browserConfiguration.getSelectedQueriesManager();
        List<SelectedQuery> selectedQueries = selectedQueriesManager.getSelectedQueriesFor(this.getEObject());
        if (selectedQueries != null && selectedQueries.size() > 0) {
            for (SelectedQuery selectedQuery : selectedQueries) {
                if (selectedQuery.getModelQuery() != null) {
                    children.add(new QueryItem(this.getEObject(), (ITreeElement)this, selectedQuery, this.browserConfiguration));
                    continue;
                }
                MoDiscoLogger.logError((String)Messages.ModelElementItem_nullQuerySelected, (Plugin)MoDiscoBrowserPlugin.getPlugin());
            }
        }
    }

    protected void addVirtualElements(List<Object> children) {
        this.addSelectedQueries(children);
    }

    public Collection<?> getChildren(Object object) {
        throw new UnsupportedOperationException();
    }

    public Object getParent(Object object) {
        return this.getTreeParent();
    }

    public Collection<?> getNewChildDescriptors(Object object, EditingDomain editingDomain, Object sibling) {
        if (sibling instanceof LinkItem) {
            return Collections.emptyList();
        }
        Resource eResource = this.getEObject().eResource();
        if (eResource != null && eResource.getURI().isPlatformResource()) {
            if (sibling != null) {
                if (this.getEObject().eContainer() != null) {
                    return EditingSupportUtil.getNewChildDescriptors((List<EReference>)this.getEObject().eContainer().eClass().getEAllReferences(), this.browserConfiguration.getResourceSet());
                }
                return Collections.EMPTY_LIST;
            }
            Collection<?> descriptors = EditingSupportUtil.getNewChildDescriptors((List<EReference>)this.getEObject().eClass().getEAllReferences(), this.browserConfiguration.getResourceSet());
            return descriptors;
        }
        return null;
    }

    public Command createCommand(Object object, EditingDomain editingDomain, Class<? extends Command> commandClass, CommandParameter commandParameter) {
        if (commandClass == DragAndDropCommand.class) {
            DragAndDropCommand.Detail detail = (DragAndDropCommand.Detail)commandParameter.getFeature();
            return new DragAndDropOnModelElementCommand(editingDomain, this, detail.location, detail.operations, detail.operation, commandParameter.getCollection());
        }
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return String.valueOf(ModelElementItemEx.class.getSimpleName()) + "{" + this.getElementID() + "}(" + this.getText() + ")" + System.identityHashCode((Object)this);
    }
}

