/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.ui.snapshot.views.inspector;

import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.query.ContextProvider;
import org.eclipse.mat.query.IContextObject;
import org.eclipse.mat.query.IContextObjectSet;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.OQL;
import org.eclipse.mat.snapshot.model.IClass;
import org.eclipse.mat.ui.snapshot.views.inspector.InspectorView;
import org.eclipse.mat.ui.snapshot.views.inspector.NamedReferenceNode;

class InspectorContextProvider
extends ContextProvider {
    ISnapshot snapshot;

    public InspectorContextProvider(ISnapshot snapshot) {
        super(null);
        this.snapshot = snapshot;
    }

    public IContextObject getContext(Object row) {
        try {
            if (row instanceof NamedReferenceNode) {
                NamedReferenceNode node = (NamedReferenceNode)row;
                final int objectId = this.snapshot.mapAddressToId(node.objectAddress);
                return new IContextObject(){

                    public int getObjectId() {
                        return objectId;
                    }
                };
            }
            if (row instanceof InspectorView.BaseNode) {
                final InspectorView.BaseNode node = (InspectorView.BaseNode)row;
                if (node.objectId >= 0) {
                    return new IContextObject(){

                        public int getObjectId() {
                            return node.objectId;
                        }
                    };
                }
                if (node.addr != Long.MIN_VALUE) {
                    return new IContextObjectSet(){

                        public int getObjectId() {
                            return -1;
                        }

                        public int[] getObjectIds() {
                            return new int[0];
                        }

                        public String getOQL() {
                            return OQL.forAddress((long)node.addr);
                        }
                    };
                }
            } else if (row instanceof IClass) {
                final IClass clazz = (IClass)row;
                return new IContextObject(){

                    public int getObjectId() {
                        return clazz.getObjectId();
                    }
                };
            }
            return null;
        }
        catch (SnapshotException e) {
            if (row instanceof NamedReferenceNode) {
                final NamedReferenceNode node = (NamedReferenceNode)row;
                return new IContextObjectSet(){

                    public int getObjectId() {
                        return -1;
                    }

                    public int[] getObjectIds() {
                        return new int[0];
                    }

                    public String getOQL() {
                        return OQL.forAddress((long)node.objectAddress);
                    }
                };
            }
            throw new RuntimeException(e);
        }
    }
}

