/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jem.internal.proxy.remote;

import org.eclipse.jem.internal.proxy.common.remote.Commands;
import org.eclipse.jem.internal.proxy.core.IBeanProxy;
import org.eclipse.jem.internal.proxy.core.IBeanTypeProxy;
import org.eclipse.jem.internal.proxy.core.INumberBeanProxy;
import org.eclipse.jem.internal.proxy.remote.REMAbstractNumberBeanTypeProxy;
import org.eclipse.jem.internal.proxy.remote.REMFloatClassBeanProxy;
import org.eclipse.jem.internal.proxy.remote.REMProxyFactoryRegistry;

final class REMFloatClassBeanTypeProxy
extends REMAbstractNumberBeanTypeProxy {
    private final INumberBeanProxy zeroProxy;

    REMFloatClassBeanTypeProxy(REMProxyFactoryRegistry aRegistry, IBeanTypeProxy numberType) {
        super(aRegistry, new Integer(12), Float.class.getName(), numberType);
        this.zeroProxy = new REMFloatClassBeanProxy(aRegistry, new Float(0.0f));
    }

    INumberBeanProxy createFloatBeanProxy(Float aFloat) {
        return aFloat.floatValue() != 0.0f ? new REMFloatClassBeanProxy(this.fRegistry, aFloat) : this.zeroProxy;
    }

    @Override
    protected INumberBeanProxy createNumberBeanProxy(Number aNumber) {
        return this.createFloatBeanProxy((Float)aNumber);
    }

    @Override
    public IBeanProxy newInstance() {
        return this.zeroProxy;
    }

    @Override
    public IBeanProxy newBeanProxy(Commands.ValueObject value) {
        return this.createFloatBeanProxy(new Float(value.aFloat));
    }
}

