/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.ui.views;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import org.eclipse.emf.cdo.internal.ui.bundle.OM;
import org.eclipse.emf.cdo.internal.ui.views.UserInfo;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.session.remote.CDORemoteSession;
import org.eclipse.emf.cdo.session.remote.CDORemoteSessionManager;
import org.eclipse.emf.cdo.session.remote.CDORemoteTopic;
import org.eclipse.emf.cdo.ui.CDOTopicProvider;
import org.eclipse.emf.cdo.ui.shared.SharedIcons;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ItemProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.net4j.ui.shared.CollapseAllAction;
import org.eclipse.net4j.ui.shared.ExpandAllAction;
import org.eclipse.net4j.ui.shared.LinkWithEditorAction;
import org.eclipse.net4j.util.AdapterUtil;
import org.eclipse.net4j.util.container.IContainerEvent;
import org.eclipse.net4j.util.container.IContainerEventVisitor;
import org.eclipse.net4j.util.event.EventUtil;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.ILifecycleEvent;
import org.eclipse.net4j.util.om.OMPlatform;
import org.eclipse.net4j.util.ui.GlobalPartAdapter;
import org.eclipse.net4j.util.ui.UIUtil;
import org.eclipse.net4j.util.ui.views.ContainerItemProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.part.ViewPart;

public class CDORemoteTopicsView
extends ViewPart
implements ISelectionProvider,
ISetSelectionTarget {
    public static final String ID = "org.eclipse.emf.cdo.ui.CDORemoteTopicsView";
    private static final boolean LOCAL_USER_INFO_HIDE = OMPlatform.INSTANCE.isProperty("org.eclipse.emf.cdo.ui.CDORemoteTopicsView.LOCAL_USER_INFO_HIDE");
    private static final boolean LOCAL_USER_INFO_DISABLE = OMPlatform.INSTANCE.isProperty("org.eclipse.emf.cdo.ui.CDORemoteTopicsView.LOCAL_USER_INFO_DISABLE");
    private static final boolean EXPAND_SELECTION = OMPlatform.INSTANCE.isProperty("org.eclipse.emf.cdo.ui.CDORemoteTopicsView.EXPAND_SELECTION");
    private AutoCloseable userInfoListener;
    private final Map<CDOTopicProvider.Topic, CDORemoteTopic> remoteTopics = new HashMap<CDOTopicProvider.Topic, CDORemoteTopic>();
    private final Map<CDORemoteTopic, RemoteTopicItem> remoteTopicItems = new HashMap<CDORemoteTopic, RemoteTopicItem>();
    private GlobalPartAdapter workbenchListener = new GlobalPartAdapter(false){

        public void partOpened(IWorkbenchPartReference partRef) {
            CDOTopicProvider provider = CDORemoteTopicsView.getTopicProvider(partRef);
            if (provider != null) {
                CDORemoteTopicsView.this.addTopics(provider.getTopics());
                provider.addTopicListener(CDORemoteTopicsView.this.topicListener);
            }
        }

        public void partClosed(IWorkbenchPartReference partRef) {
            CDOTopicProvider provider = CDORemoteTopicsView.getTopicProvider(partRef);
            if (provider != null) {
                provider.removeTopicListener(CDORemoteTopicsView.this.topicListener);
                CDORemoteTopicsView.this.removeTopics(provider.getTopics());
            }
        }

        public void partActivated(IWorkbenchPartReference partRef) {
            CDOTopicProvider provider;
            if (CDORemoteTopicsView.this.linkWithEditor && (provider = CDORemoteTopicsView.getTopicProvider(partRef)) != null) {
                CDORemoteTopicsView.this.selectTopics(provider.getTopics());
            }
        }
    };
    private final CDOTopicProvider.Listener topicListener = new CDOTopicProvider.Listener(){

        @Override
        public void topicAdded(CDOTopicProvider provider, CDOTopicProvider.Topic topic) {
            CDORemoteTopicsView.this.addTopics(topic);
        }

        @Override
        public void topicRemoved(CDOTopicProvider provider, CDOTopicProvider.Topic topic) {
            CDORemoteTopicsView.this.removeTopics(topic);
        }
    };
    private final AdapterFactory adapterFactory = new ComposedAdapterFactory();
    private final ItemProvider root = new ItemProvider(this.adapterFactory);
    private Shell shell;
    private TreeViewer viewer;
    private boolean linkWithEditor = (Boolean)OM.PREF_TOPICS_LINK_WITH_EDITOR.getValue();
    private boolean inEditorActivation;
    private ISelectionChangedListener selectionListener = event -> {
        if (!this.inEditorActivation) {
            ITreeSelection selection = (ITreeSelection)event.getSelection();
            IActionBars bars = this.getViewSite().getActionBars();
            this.selectionChanged(bars, selection);
        }
    };

    public Shell getShell() {
        return this.shell;
    }

    public TreeViewer getViewer() {
        return this.viewer;
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public void dispose() {
        this.workbenchListener.dispose();
        try {
            this.userInfoListener.close();
        }
        catch (Exception ex) {
            OM.LOG.error((Throwable)ex);
        }
        super.dispose();
    }

    public ISelection getSelection() {
        if (this.viewer != null) {
            return this.viewer.getSelection();
        }
        return StructuredSelection.EMPTY;
    }

    public void setSelection(ISelection selection) {
        if (this.viewer != null) {
            this.viewer.setSelection(selection);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.viewer != null) {
            this.viewer.addSelectionChangedListener(listener);
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.viewer != null) {
            this.viewer.removeSelectionChangedListener(listener);
        }
    }

    public void selectReveal(ISelection selection) {
        if (this.viewer != null) {
            this.viewer.setSelection(selection, true);
        }
    }

    public final void createPartControl(Composite parent) {
        this.shell = parent.getShell();
        Composite composite = UIUtil.createGridComposite((Composite)parent, (int)1);
        Control control = this.createUI(composite);
        control.setLayoutData((Object)UIUtil.createGridData());
        this.hookContextMenu();
        this.hookDoubleClick();
        this.contributeToActionBars();
        this.workbenchListener.register(true);
        this.getSite().setSelectionProvider((ISelectionProvider)this);
    }

    protected Control createUI(Composite parent) {
        AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider(this.adapterFactory);
        labelProvider.setFireLabelUpdateNotifications(true);
        this.viewer = new TreeViewer(parent, 770);
        this.viewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(this.adapterFactory));
        this.viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.viewer.setComparator(new ViewerComparator());
        this.viewer.setInput((Object)this.root);
        this.viewer.addSelectionChangedListener(this.selectionListener);
        this.userInfoListener = EventUtil.addListener((Object)((Object)UserInfo.Manager.INSTANCE), UserInfo.Manager.UserChangedEvent.class, e -> {
            CDORemoteSession remoteSession = e.getRemoteSession();
            if (remoteSession != null) {
                for (Object topic : this.root.getChildren()) {
                    for (Object child : ((RemoteTopicItem)((Object)((Object)topic))).getChildren()) {
                        RemoteMemberItem member = (RemoteMemberItem)((Object)((Object)child));
                        if (member.getRemoteSession() != remoteSession) continue;
                        UIUtil.asyncExec(() -> member.updateText());
                    }
                }
            }
        });
        return this.viewer.getControl();
    }

    protected void hookDoubleClick() {
        this.viewer.addDoubleClickListener(e -> this.doubleClicked(((ITreeSelection)this.viewer.getSelection()).getFirstElement()));
    }

    protected void hookContextMenu() {
        MenuManager manager = new MenuManager("#PopupMenu");
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(m -> this.fillContextMenu(m, (ITreeSelection)this.viewer.getSelection()));
        Menu menu = manager.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getViewSite().registerContextMenu(manager, (ISelectionProvider)this.viewer);
    }

    protected void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    protected void fillLocalPullDown(IMenuManager manager) {
    }

    protected void fillLocalToolBar(final IToolBarManager manager) {
        if (!LOCAL_USER_INFO_HIDE) {
            final UserInfo localUser = UserInfo.Manager.INSTANCE.getLocalUser();
            manager.add((IAction)new Action(localUser.getDisplayName(), 1){
                {
                    super($anonymous0, $anonymous1);
                    this.setToolTipText("Change Local Name");
                    this.setEnabled(!LOCAL_USER_INFO_DISABLE);
                }

                public void run() {
                    String displayName = localUser.getDisplayName();
                    InputDialog dialog = new InputDialog(CDORemoteTopicsView.this.getShell(), this.getToolTipText(), "Local name:", displayName, null);
                    if (dialog.open() == 0) {
                        String newDisplayName = dialog.getValue();
                        UserInfo.Manager.INSTANCE.changeLocalUser(localUser.getFirstName(), localUser.getLastName(), newDisplayName);
                        newDisplayName = localUser.getDisplayName();
                        if (!Objects.equals(newDisplayName, displayName)) {
                            this.setText(newDisplayName);
                            if (manager instanceof ToolBarManager) {
                                ToolBar toolBar = ((ToolBarManager)manager).getControl();
                                toolBar.getParent().pack(true);
                            }
                        }
                    }
                }
            });
        }
        manager.add((IAction)new ExpandAllAction(this.viewer));
        manager.add((IAction)new CollapseAllAction(this.viewer));
        LinkWithEditorAction linkAction = new LinkWithEditorAction(){

            protected void linkWithEditorChanged(boolean linkWithEditor) {
                CDORemoteTopicsView.this.linkWithEditor = linkWithEditor;
                OM.PREF_TOPICS_LINK_WITH_EDITOR.setValue((Object)linkWithEditor);
            }
        };
        linkAction.setChecked(this.linkWithEditor);
        manager.add((IAction)linkAction);
    }

    protected void fillContextMenu(IMenuManager manager, ITreeSelection selection) {
    }

    protected void selectionChanged(IActionBars bars, ITreeSelection selection) {
        if (this.linkWithEditor) {
            IWorkbenchPage activePage;
            RemoteTopicItem remoteTopicItem;
            CDOTopicProvider.Topic topic;
            Object element = selection.getFirstElement();
            if (element instanceof RemoteMemberItem) {
                element = ((RemoteMemberItem)((Object)element)).getParent();
            }
            if (element instanceof RemoteTopicItem && !CDORemoteTopicsView.activatePart(topic = (remoteTopicItem = (RemoteTopicItem)((Object)element)).getTopic(), (IWorkbenchPartReference[])(activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()).getEditorReferences())) {
                CDORemoteTopicsView.activatePart(topic, (IWorkbenchPartReference[])activePage.getViewReferences());
            }
        }
    }

    protected void doubleClicked(Object object) {
        if (object instanceof ContainerItemProvider.ErrorElement) {
            try {
                UIUtil.getActiveWorkbenchPage().showView("org.eclipse.pde.runtime.LogView");
            }
            catch (PartInitException ex) {
                OM.LOG.error((Throwable)ex);
            }
        } else if (object != null && this.viewer.isExpandable(object)) {
            if (this.viewer.getExpandedState(object)) {
                this.viewer.collapseToLevel(object, -1);
            } else {
                this.viewer.expandToLevel(object, 1);
            }
        }
    }

    protected void refreshPressed() {
        UIUtil.refreshViewer((Viewer)this.viewer);
    }

    protected void collapseAllPressed() {
        this.getViewer().collapseAll();
    }

    protected void closeView() {
        UIUtil.syncExec((Display)this.getDisplay(), () -> {
            this.getSite().getPage().hideView((IViewPart)this);
            this.dispose();
        });
    }

    protected Display getDisplay() {
        Display display = this.viewer.getControl().getDisplay();
        if (display == null) {
            display = UIUtil.getDisplay();
        }
        return display;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CDOTopicProvider.Topic getTopic(CDORemoteTopic remoteTopic) {
        Map<CDOTopicProvider.Topic, CDORemoteTopic> map = this.remoteTopics;
        synchronized (map) {
            RemoteTopicItem item = this.remoteTopicItems.get(remoteTopic);
            return item == null ? null : item.getTopic();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTopics(CDOTopicProvider.Topic ... topics) {
        Map<CDOTopicProvider.Topic, CDORemoteTopic> map = this.remoteTopics;
        synchronized (map) {
            CDOTopicProvider.Topic[] topicArray = topics;
            int n = topics.length;
            int n2 = 0;
            while (n2 < n) {
                CDOTopicProvider.Topic topic = topicArray[n2];
                CDORemoteTopic remoteTopic = this.remoteTopics.computeIfAbsent(topic, k -> {
                    CDOSession session = topic.getSession();
                    String id = topic.getId();
                    CDORemoteSessionManager remoteSessionManager = session.getRemoteSessionManager();
                    return remoteSessionManager.subscribeTopic(id);
                });
                RemoteTopicItem item = this.remoteTopicItems.computeIfAbsent(remoteTopic, k -> {
                    RemoteTopicItem newItem = new RemoteTopicItem(topic, remoteTopic);
                    this.root.getChildren().add((Object)newItem);
                    return newItem;
                });
                item.reference();
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeTopics(CDOTopicProvider.Topic ... topics) {
        Map<CDOTopicProvider.Topic, CDORemoteTopic> map = this.remoteTopics;
        synchronized (map) {
            CDOTopicProvider.Topic[] topicArray = topics;
            int n = topics.length;
            int n2 = 0;
            while (n2 < n) {
                RemoteTopicItem item;
                CDOTopicProvider.Topic topic = topicArray[n2];
                CDORemoteTopic remoteTopic = this.remoteTopics.get(topic);
                if (remoteTopic != null && (item = this.remoteTopicItems.get(remoteTopic)).dereference() == 0) {
                    remoteTopic.unsubscribe();
                    this.remoteTopics.remove(topic);
                    this.remoteTopicItems.remove(remoteTopic);
                    this.root.getChildren().remove((Object)item);
                }
                ++n2;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void selectTopics(CDOTopicProvider.Topic ... topics) {
        ArrayList<RemoteTopicItem> items = new ArrayList<RemoteTopicItem>();
        Map<CDOTopicProvider.Topic, CDORemoteTopic> map = this.remoteTopics;
        synchronized (map) {
            CDOTopicProvider.Topic[] topicArray = topics;
            int n = topics.length;
            int n2 = 0;
            while (n2 < n) {
                RemoteTopicItem item;
                CDOTopicProvider.Topic topic = topicArray[n2];
                CDORemoteTopic remoteTopic = this.remoteTopics.get(topic);
                if (remoteTopic != null && (item = this.remoteTopicItems.get(remoteTopic)) != null) {
                    items.add(item);
                }
                ++n2;
            }
        }
        try {
            this.inEditorActivation = true;
            StructuredSelection selection = new StructuredSelection(items);
            this.viewer.setSelection((ISelection)selection);
            if (EXPAND_SELECTION) {
                this.viewer.setExpandedElements(items.toArray());
            }
        }
        finally {
            this.inEditorActivation = false;
        }
    }

    private static CDOTopicProvider getTopicProvider(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(true);
        return (CDOTopicProvider)AdapterUtil.adapt((Object)part, CDOTopicProvider.class);
    }

    private static boolean activatePart(CDOTopicProvider.Topic selectedTopic, IWorkbenchPartReference[] partRefs) {
        IWorkbenchPartReference[] iWorkbenchPartReferenceArray = partRefs;
        int n = partRefs.length;
        int n2 = 0;
        while (n2 < n) {
            IWorkbenchPartReference partRef = iWorkbenchPartReferenceArray[n2];
            CDOTopicProvider topicProvider = CDORemoteTopicsView.getTopicProvider(partRef);
            if (topicProvider != null) {
                CDOTopicProvider.Topic[] topicArray = topicProvider.getTopics();
                int n3 = topicArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    CDOTopicProvider.Topic topic = topicArray[n4];
                    if (Objects.equals(topic, selectedTopic)) {
                        partRef.getPage().activate(partRef.getPart(true));
                        return true;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return false;
    }

    private class Item
    extends ItemProvider {
        protected Item() {
            super(CDORemoteTopicsView.this.adapterFactory);
        }

        public void setText(Object object, String text) {
            this.text = text;
            this.fireNotifyChanged((Notification)new ItemProvider.ItemProviderNotification(this, 1, null, text, -1, false, false, true){

                public boolean isLabelUpdate() {
                    return this.isLabelUpdate;
                }
            });
        }
    }

    private final class RemoteMemberItem
    extends Item {
        private final CDORemoteSession remoteSession;

        public RemoteMemberItem(CDORemoteSession remoteSession) {
            this.remoteSession = remoteSession;
            this.setImage(SharedIcons.getImage((String)"obj16/person.gif"));
            this.updateText();
        }

        public void updateText() {
            UserInfo userInfo = UserInfo.Manager.INSTANCE.getRemoteUser(this.remoteSession);
            this.setText(userInfo.getDisplayName());
        }

        public CDORemoteSession getRemoteSession() {
            return this.remoteSession;
        }
    }

    private final class RemoteTopicItem
    extends Item
    implements IListener {
        private final CDOTopicProvider.Topic topic;
        private final CDORemoteTopic remoteTopic;
        private int refCount;

        public RemoteTopicItem(CDOTopicProvider.Topic topic, CDORemoteTopic remoteTopic) {
            this.topic = topic;
            this.remoteTopic = remoteTopic;
            this.setImage(topic.getImage());
            this.setText(topic.getText());
            ArrayList<RemoteMemberItem> children = new ArrayList<RemoteMemberItem>();
            CDORemoteSession[] cDORemoteSessionArray = remoteTopic.getRemoteSessions();
            int n = cDORemoteSessionArray.length;
            int n2 = 0;
            while (n2 < n) {
                CDORemoteSession remoteSession = cDORemoteSessionArray[n2];
                RemoteMemberItem item = new RemoteMemberItem(remoteSession);
                children.add(item);
                ++n2;
            }
            this.getChildren().addAll(children);
            remoteTopic.addListener((IListener)this);
        }

        public CDOTopicProvider.Topic getTopic() {
            return this.topic;
        }

        public void notifyEvent(IEvent event) {
            if (event instanceof ILifecycleEvent) {
                ILifecycleEvent e = (ILifecycleEvent)event;
                if (e.getKind() == ILifecycleEvent.Kind.DEACTIVATED) {
                    this.dispose();
                }
            } else if (event instanceof IContainerEvent) {
                IContainerEvent e = (IContainerEvent)event;
                UIUtil.asyncExec(() -> e.accept((IContainerEventVisitor)new IContainerEventVisitor<CDORemoteSession>(){

                    public void added(CDORemoteSession remoteSession) {
                        RemoteMemberItem item = new RemoteMemberItem(remoteSession);
                        RemoteTopicItem.this.getChildren().add((Object)item);
                    }

                    public void removed(CDORemoteSession remoteSession) {
                        Iterator it = RemoteTopicItem.this.getChildren().iterator();
                        while (it.hasNext()) {
                            RemoteMemberItem item = (RemoteMemberItem)((Object)it.next());
                            if (item.getRemoteSession() != remoteSession) continue;
                            it.remove();
                            break;
                        }
                    }
                }));
            }
        }

        public void dispose() {
            this.remoteTopic.removeListener((IListener)this);
        }

        private void reference() {
            ++this.refCount;
        }

        private int dereference() {
            return --this.refCount;
        }
    }
}

