/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.branch;

import java.text.MessageFormat;
import org.eclipse.emf.cdo.common.branch.CDOBranch;
import org.eclipse.emf.cdo.common.branch.CDOBranchPoint;
import org.eclipse.emf.cdo.common.branch.CDOBranchTag;
import org.eclipse.emf.cdo.common.util.CDOCommonUtil;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchUtil;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranch;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.net4j.util.CheckUtil;
import org.eclipse.net4j.util.event.Event;
import org.eclipse.net4j.util.event.INotifier;
import org.eclipse.net4j.util.event.Notifier;

public class CDOBranchTagImpl
extends Notifier
implements CDOBranchTag {
    private String name;
    private InternalCDOBranch branch;
    private long timeStamp;

    public CDOBranchTagImpl(String name, CDOBranch branch, long timeStamp) {
        CDOBranchTagImpl.checkName(name);
        CDOBranchTagImpl.checkBranchPoint(branch, timeStamp);
        this.name = name;
        this.branch = (InternalCDOBranch)branch;
        this.timeStamp = timeStamp;
    }

    @Override
    public CDOBranch getBranch() {
        return this.branch;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public InternalCDOBranchManager getBranchManager() {
        if (this.branch != null) {
            return this.branch.getBranchManager();
        }
        return null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        CDOBranchTagImpl.checkName(name);
        if (name.equals(this.name)) {
            return;
        }
        InternalCDOBranchManager branchManager = this.getBranchManager();
        branchManager.renameTag(this.name, name);
    }

    void setNameInternal(String name) {
        this.name = name;
    }

    void fireTagRenamedEvent(String oldName, String newName) {
        this.fireEvent(new TagRenamedEventImpl(this, oldName, newName));
    }

    @Override
    public void move(CDOBranchPoint branchPoint) {
        CDOBranch newBranch = branchPoint.getBranch();
        long newTimeStamp = branchPoint.getTimeStamp();
        CDOBranchTagImpl.checkBranchPoint(newBranch, newTimeStamp);
        branchPoint = CDOBranchUtil.adjustBranchPoint(branchPoint, this.getBranchManager());
        if (branchPoint.equals(CDOBranchUtil.copyBranchPoint(this))) {
            return;
        }
        InternalCDOBranchManager branchManager = this.getBranchManager();
        branchManager.moveTag(this, branchPoint);
        this.moveInternal(newBranch, newTimeStamp);
    }

    void moveInternal(CDOBranch branch, long timeStamp) {
        this.branch = (InternalCDOBranch)branch;
        this.timeStamp = timeStamp;
    }

    void fireTagMovedEvent(CDOBranchPoint oldBranchPoint, CDOBranchPoint newBranchPoint) {
        this.fireEvent(new TagMovedEventImpl(this, oldBranchPoint, newBranchPoint));
    }

    @Override
    public void delete() {
        if (!this.isDeleted()) {
            InternalCDOBranchManager branchManager = this.getBranchManager();
            branchManager.deleteTag(this);
            this.deleteInternal();
        }
    }

    void deleteInternal() {
        this.branch = null;
        this.timeStamp = 0L;
    }

    void fireTagDeletedEvent() {
        this.fireEvent(new TagDeletedEventImpl(this));
    }

    @Override
    public boolean isDeleted() {
        return this.branch == null;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public int compareTo(CDOBranchTag o) {
        long ts1 = this.timeStamp;
        long ts2 = o.getTimeStamp();
        if (ts1 == ts2) {
            int b1 = this.branch.getID();
            int b2 = o.getBranch().getID();
            return Integer.compare(b1, b2);
        }
        return Long.compare(ts1, ts2);
    }

    public String toString() {
        return MessageFormat.format("BranchTag[{0}, {1}, {2}]", this.name, this.branch, CDOCommonUtil.formatTimeStamp(this.timeStamp));
    }

    private static void checkName(String name) {
        CheckUtil.checkArg((name != null && !name.isEmpty() ? 1 : 0) != 0, (String)"Invalid name");
    }

    private static void checkBranchPoint(CDOBranch branch, long timeStamp) {
        CheckUtil.checkArg((Object)branch, (String)"branch");
        CheckUtil.checkArg((timeStamp > 0L ? 1 : 0) != 0, (String)"Invalid timeStamp");
    }

    public static final class TagDeletedEventImpl
    extends TagEventImpl
    implements CDOBranchTag.TagDeletedEvent {
        private static final long serialVersionUID = 1L;

        public TagDeletedEventImpl(CDOBranchTagImpl tag) {
            super(tag);
        }
    }

    public static abstract class TagEventImpl
    extends Event
    implements CDOBranchTag.TagEvent {
        private static final long serialVersionUID = 1L;

        public TagEventImpl(CDOBranchTagImpl tag) {
            super((INotifier)tag);
        }

        @Override
        public CDOBranchTag getTag() {
            return (CDOBranchTag)this.getSource();
        }
    }

    public static final class TagMovedEventImpl
    extends TagEventImpl
    implements CDOBranchTag.TagMovedEvent {
        private static final long serialVersionUID = 1L;
        private final CDOBranchPoint oldBranchPoint;
        private final CDOBranchPoint newBranchPoint;

        public TagMovedEventImpl(CDOBranchTagImpl tag, CDOBranchPoint oldBranchPoint, CDOBranchPoint newBranchPoint) {
            super(tag);
            this.oldBranchPoint = oldBranchPoint;
            this.newBranchPoint = newBranchPoint;
        }

        @Override
        public CDOBranchPoint getOldBranchPoint() {
            return this.oldBranchPoint;
        }

        @Override
        public CDOBranchPoint getNewBranchPoint() {
            return this.newBranchPoint;
        }

        protected String formatAdditionalParameters() {
            return "oldBranchPoint=" + this.oldBranchPoint + ", newBranchPoint=" + this.newBranchPoint;
        }
    }

    public static final class TagRenamedEventImpl
    extends TagEventImpl
    implements CDOBranchTag.TagRenamedEvent {
        private static final long serialVersionUID = 1L;
        private final String oldName;
        private final String newName;

        public TagRenamedEventImpl(CDOBranchTagImpl tag, String oldName, String newName) {
            super(tag);
            this.oldName = oldName;
            this.newName = newName;
        }

        @Override
        public String getOldName() {
            return this.oldName;
        }

        @Override
        public String getNewName() {
            return this.newName;
        }

        protected String formatAdditionalParameters() {
            return "oldName=" + this.oldName + ", newName=" + this.newName;
        }
    }
}

