/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui.wizards;

import java.net.URL;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.connectivity.ui.wizards.IWizardCategoryProvider;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.graphics.Image;

public class WizardCategoryProvider
implements IWizardCategoryProvider {
    public static final String ATTR_ID = "id";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_ICON = "icon";
    public static final String ATTR_DESC = "description";
    public static final String ATTR_PARENT = "parentCategory";
    public static final String ATTR_WIZARD_TITLE = "wizardTitle";
    public static final String ATTR_WIZARD_DESC = "wizardDescription";
    private String mId;
    private String mName;
    private ImageDescriptor mIcon;
    private Image mCachedIcon;
    private String mDescription;
    private String mParentCategory;
    private String mWizardTitle;
    private String mWizardDescription;
    private IConfigurationElement mElement;

    public WizardCategoryProvider(IConfigurationElement element) {
        this.init(element);
    }

    private void init(IConfigurationElement element) {
        Assert.isTrue((boolean)"wizardCategory".equals(element.getName()));
        this.mElement = element;
        this.mId = element.getAttribute(ATTR_ID);
        this.mName = element.getAttribute(ATTR_NAME);
        this.mDescription = element.getAttribute(ATTR_DESC);
        this.mParentCategory = element.getAttribute(ATTR_PARENT);
        if (this.mParentCategory == null) {
            this.mParentCategory = "";
        }
        this.mWizardTitle = element.getAttribute(ATTR_WIZARD_TITLE);
        this.mWizardDescription = element.getAttribute(ATTR_WIZARD_DESC);
        this.processIconAttr();
    }

    private void processIconAttr() {
        String iconAttr = this.mElement.getAttribute(ATTR_ICON);
        if (iconAttr != null && iconAttr.trim().length() > 0) {
            URL url = Platform.getBundle((String)this.mElement.getContributor().getName()).getEntry(iconAttr);
            this.mIcon = ImageDescriptor.createFromURL((URL)url);
        } else {
            this.mIcon = ImageDescriptor.getMissingImageDescriptor();
        }
    }

    @Override
    public ImageDescriptor getIcon() {
        return this.mIcon;
    }

    @Override
    public Image getCachedIcon() {
        if (this.mCachedIcon == null) {
            this.mCachedIcon = this.mIcon.createImage();
        }
        return this.mCachedIcon;
    }

    @Override
    public String getId() {
        return this.mId;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    @Override
    public String getDescription() {
        return this.mDescription;
    }

    @Override
    public String getCategory() {
        return this.mParentCategory;
    }

    @Override
    public IWizard getWizard() {
        return null;
    }

    @Override
    public String getWizardDescription() {
        return this.mWizardDescription;
    }

    @Override
    public String getWizardTitle() {
        return this.mWizardTitle;
    }
}

