/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.merrimac.dialogs;

import org.eclipse.bpmn2.modeler.core.Activator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class StyledTextInputDialog
extends Dialog {
    private String title;
    private String message;
    private String value = "";
    private IInputValidator validator;
    private Button okButton;
    private StyledText text;
    private Text errorMessageText;
    private String errorMessage;
    protected IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();

    public StyledTextInputDialog(Shell parentShell, String dialogTitle, String dialogMessage, String initialValue, IInputValidator validator) {
        super(parentShell);
        this.title = dialogTitle;
        this.message = dialogMessage;
        this.value = initialValue == null ? "" : initialValue;
        this.validator = validator;
    }

    protected void buttonPressed(int buttonId) {
        this.value = buttonId == 0 ? this.text.getText() : null;
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected String getPreferenceKey() {
        return this.title == null ? null : this.title.replaceAll(" ", "_");
    }

    protected void initializeBounds() {
        final String key = this.getPreferenceKey();
        if (key != null && !key.isEmpty()) {
            int y;
            int height;
            Point p = this.getShell().getSize();
            int width = this.preferenceStore.getInt("dialog." + key + ".width");
            if (width == 0) {
                width = p.x;
            }
            if ((height = this.preferenceStore.getInt("dialog." + key + ".height")) == 0) {
                height = p.y;
            }
            this.getShell().setSize(width, height);
            p = this.getShell().getLocation();
            int x = this.preferenceStore.getInt("dialog." + key + ".x");
            if (x == 0) {
                x = p.x;
            }
            if ((y = this.preferenceStore.getInt("dialog." + key + ".y")) == 0) {
                y = p.y;
            }
            this.getShell().setLocation(x, y);
            this.getShell().addControlListener(new ControlListener(){

                public void controlMoved(ControlEvent e) {
                    Point p = StyledTextInputDialog.this.getShell().getLocation();
                    StyledTextInputDialog.this.preferenceStore.setValue("dialog." + key + ".x", p.x);
                    StyledTextInputDialog.this.preferenceStore.setValue("dialog." + key + ".y", p.y);
                }

                public void controlResized(ControlEvent e) {
                    Point p = StyledTextInputDialog.this.getShell().getSize();
                    StyledTextInputDialog.this.preferenceStore.setValue("dialog." + key + ".width", p.x);
                    StyledTextInputDialog.this.preferenceStore.setValue("dialog." + key + ".height", p.y);
                }
            });
        } else {
            super.initializeBounds();
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.text.setFocus();
        if (this.value != null) {
            this.text.setText(this.value);
            this.text.selectAll();
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        if (this.message != null) {
            Label label = new Label(composite, 64);
            label.setText(this.message);
            GridData data = new GridData(772);
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            label.setLayoutData((Object)data);
            label.setFont(parent.getFont());
        }
        this.text = this.createText(composite);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StyledTextInputDialog.this.validateInput();
            }
        });
        this.errorMessageText = new Text(composite, 8);
        this.errorMessageText.setLayoutData((Object)new GridData(768));
        this.errorMessageText.setBackground(this.errorMessageText.getDisplay().getSystemColor(22));
        this.setErrorMessage(this.errorMessage);
        StyledTextInputDialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected StyledText createText(Composite composite) {
        StyledText text = new StyledText(composite, 2052);
        text.setLayoutData((Object)new GridData(768));
        return text;
    }

    @Deprecated
    protected Label getErrorMessageLabel() {
        return null;
    }

    protected Button getOkButton() {
        return this.okButton;
    }

    protected StyledText getText() {
        return this.text;
    }

    protected IInputValidator getValidator() {
        return this.validator;
    }

    public String getValue() {
        return this.value;
    }

    protected void validateInput() {
        String errorMessage = null;
        if (this.validator != null) {
            errorMessage = this.validator.isValid(this.text.getText());
        }
        this.setErrorMessage(errorMessage);
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        if (this.errorMessageText != null && !this.errorMessageText.isDisposed()) {
            this.errorMessageText.setText(errorMessage == null ? "" : errorMessage);
            this.errorMessageText.getParent().update();
            Button button = this.getButton(0);
            if (button != null) {
                button.setEnabled(errorMessage == null);
            }
        }
    }
}

