/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.npipe;

import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.SocketChannel;
import org.mandas.docker.client.npipe.NpipeSocketAddress;

public class NamedPipeSocket
extends Socket {
    private final Object connectLock = new Object();
    private volatile boolean inputShutdown;
    private volatile boolean outputShutdown;
    private String socketPath;
    private volatile SocketAddress socketAddress;
    private RandomAccessFile namedPipe;
    private FileChannel channel;

    NamedPipeSocket() throws IOException {
    }

    @Override
    public void connect(SocketAddress endpoint) throws IOException {
        this.connect(endpoint, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(SocketAddress endpoint, int timeout) throws IOException {
        if (timeout < 0) {
            throw new IllegalArgumentException("Timeout may not be negative: " + timeout);
        }
        if (!(endpoint instanceof NpipeSocketAddress)) {
            throw new IllegalArgumentException("Unsupported address type: " + endpoint.getClass().getName());
        }
        this.socketAddress = endpoint;
        this.socketPath = ((NpipeSocketAddress)endpoint).path();
        Object object = this.connectLock;
        synchronized (object) {
            this.namedPipe = new RandomAccessFile(this.socketPath, "rw");
            this.channel = this.namedPipe.getChannel();
        }
    }

    @Override
    public void bind(SocketAddress bindpoint) throws IOException {
        throw new SocketException("Bind is not supported");
    }

    @Override
    public InetAddress getInetAddress() {
        return null;
    }

    @Override
    public InetAddress getLocalAddress() {
        return null;
    }

    @Override
    public int getPort() {
        return -1;
    }

    @Override
    public int getLocalPort() {
        return -1;
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return this.socketAddress;
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return null;
    }

    @Override
    public SocketChannel getChannel() {
        return null;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (!this.channel.isOpen()) {
            throw new SocketException("Socket is closed");
        }
        if (this.inputShutdown) {
            throw new SocketException("Socket input is shutdown");
        }
        return new FilterInputStream(Channels.newInputStream(this.channel)){

            @Override
            public void close() throws IOException {
                NamedPipeSocket.this.shutdownInput();
            }
        };
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (!this.channel.isOpen()) {
            throw new SocketException("Socket is closed");
        }
        if (this.outputShutdown) {
            throw new SocketException("Socket output is shutdown");
        }
        return new FilterOutputStream(Channels.newOutputStream(this.channel)){

            @Override
            public void close() throws IOException {
                NamedPipeSocket.this.shutdownOutput();
            }
        };
    }

    @Override
    public void sendUrgentData(int data) throws IOException {
        throw new SocketException("Urgent data not supported");
    }

    @Override
    public void setSoTimeout(int timeout) {
    }

    @Override
    public int getSoTimeout() throws SocketException {
        return 0;
    }

    @Override
    public void setSendBufferSize(int size) throws SocketException {
        if (size <= 0) {
            throw new IllegalArgumentException("Send buffer size must be positive: " + size);
        }
        if (!this.channel.isOpen()) {
            throw new SocketException("Socket is closed");
        }
    }

    @Override
    public synchronized int getSendBufferSize() throws SocketException {
        if (!this.channel.isOpen()) {
            throw new SocketException("Socket is closed");
        }
        throw new UnsupportedOperationException("Getting the send buffer size is not supported");
    }

    @Override
    public synchronized void setReceiveBufferSize(int size) throws SocketException {
        if (size <= 0) {
            throw new IllegalArgumentException("Receive buffer size must be positive: " + size);
        }
        if (!this.channel.isOpen()) {
            throw new SocketException("Socket is closed");
        }
    }

    @Override
    public synchronized int getReceiveBufferSize() throws SocketException {
        if (!this.channel.isOpen()) {
            throw new SocketException("Socket is closed");
        }
        throw new UnsupportedOperationException("Getting the receive buffer size is not supported");
    }

    @Override
    public void setKeepAlive(boolean on) throws SocketException {
    }

    @Override
    public boolean getKeepAlive() throws SocketException {
        return true;
    }

    @Override
    public void setTrafficClass(int tc) throws SocketException {
        if (tc < 0 || tc > 255) {
            throw new IllegalArgumentException("Traffic class is not in range 0 -- 255: " + tc);
        }
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
    }

    @Override
    public int getTrafficClass() throws SocketException {
        throw new UnsupportedOperationException("Getting the traffic class is not supported");
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        throw new UnsupportedOperationException("Getting the SO_REUSEADDR option is not supported");
    }

    @Override
    public void close() throws IOException {
        if (this.isClosed()) {
            return;
        }
        if (this.channel != null) {
            this.channel.close();
        }
        this.inputShutdown = true;
        this.outputShutdown = true;
    }

    @Override
    public void shutdownInput() throws IOException {
        this.inputShutdown = true;
    }

    @Override
    public void shutdownOutput() throws IOException {
        this.outputShutdown = true;
    }

    @Override
    public String toString() {
        if (this.isConnected()) {
            return "WindowsPipe[addr=" + this.socketPath + ']';
        }
        return "WindowsPipe[unconnected]";
    }

    @Override
    public boolean isConnected() {
        return !this.isClosed();
    }

    @Override
    public boolean isBound() {
        return false;
    }

    @Override
    public boolean isClosed() {
        return this.channel != null && !this.channel.isOpen();
    }

    @Override
    public boolean isInputShutdown() {
        return this.inputShutdown;
    }

    @Override
    public boolean isOutputShutdown() {
        return this.outputShutdown;
    }

    @Override
    public void setPerformancePreferences(int connectionTime, int latency, int bandwidth) {
    }
}

