/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.localsearch.operations.extend;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.eclipse.viatra.query.runtime.localsearch.MatchingFrame;
import org.eclipse.viatra.query.runtime.localsearch.matcher.ISearchContext;
import org.eclipse.viatra.query.runtime.localsearch.operations.IPatternMatcherOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.ISearchOperation;
import org.eclipse.viatra.query.runtime.localsearch.operations.extend.SingleValueExtendOperationExecutor;
import org.eclipse.viatra.query.runtime.localsearch.operations.util.CallInformation;
import org.eclipse.viatra.query.runtime.matchers.backend.IQueryResultProvider;
import org.eclipse.viatra.query.runtime.matchers.psystem.aggregations.IMultisetAggregationOperator;
import org.eclipse.viatra.query.runtime.matchers.psystem.basicdeferred.AggregatorConstraint;
import org.eclipse.viatra.query.runtime.matchers.tuple.IModifiableTuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.ITuple;
import org.eclipse.viatra.query.runtime.matchers.tuple.VolatileModifiableMaskedTuple;

public class AggregatorExtend
implements ISearchOperation,
IPatternMatcherOperation {
    private final AggregatorConstraint aggregator;
    private final CallInformation information;
    private final int position;

    public AggregatorExtend(CallInformation information, AggregatorConstraint aggregator, int position) {
        this.aggregator = aggregator;
        this.information = information;
        this.position = position;
    }

    @Override
    public ISearchOperation.ISearchOperationExecutor createExecutor() {
        return new Executor(this.position);
    }

    @Override
    public List<Integer> getVariablePositions() {
        return Arrays.asList(this.position);
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    @Override
    public String toString(Function<Integer, String> variableMapping) {
        return "extend    -" + variableMapping.apply(this.position) + " = " + this.aggregator.getAggregator().getOperator().getName() + " find " + this.information.toString(variableMapping);
    }

    @Override
    public CallInformation getCallInformation() {
        return this.information;
    }

    private class Executor
    extends SingleValueExtendOperationExecutor<Object> {
        private final VolatileModifiableMaskedTuple maskedTuple;
        private IQueryResultProvider matcher;

        public Executor(int position) {
            super(position);
            this.maskedTuple = new VolatileModifiableMaskedTuple(AggregatorExtend.this.information.getThinFrameMask());
        }

        @Override
        public Iterator<?> getIterator(MatchingFrame frame, ISearchContext context) {
            this.maskedTuple.updateTuple((IModifiableTuple)frame);
            this.matcher = context.getMatcher(AggregatorExtend.this.information.getCallWithAdornment());
            Object aggregate = this.aggregate(AggregatorExtend.this.aggregator.getAggregator().getOperator(), AggregatorExtend.this.aggregator.getAggregatedColumn());
            return aggregate == null ? Collections.emptyIterator() : Collections.singletonList(aggregate).iterator();
        }

        private <Domain, Accumulator, AggregateResult> AggregateResult aggregate(IMultisetAggregationOperator<Domain, Accumulator, AggregateResult> operator, int aggregatedColumn) {
            Stream<Object> valueStream = this.matcher.getAllMatches(AggregatorExtend.this.information.getParameterMask(), (ITuple)this.maskedTuple).map(match -> match.get(aggregatedColumn));
            return (AggregateResult)operator.aggregateStream(valueStream);
        }

        @Override
        public ISearchOperation getOperation() {
            return AggregatorExtend.this;
        }
    }
}

