/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.photran.internal.core.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class SetOfPairs<K, V>
implements Cloneable {
    protected final HashMap<K, HashSet<V>> data = new HashMap();

    public void clear() {
        this.data.clear();
    }

    public void add(K key, V value) {
        if (!this.data.containsKey(key)) {
            this.data.put(key, new HashSet());
        }
        this.data.get(key).add(value);
    }

    public void remove(K key) {
        this.data.remove(key);
    }

    public boolean contains(K key, V value) {
        return this.data.containsKey(key) && this.data.get(key).contains(value);
    }

    public SetOfPairs<K, V> clone() {
        try {
            SetOfPairs clone = (SetOfPairs)super.clone();
            for (K filename : clone.data.keySet()) {
                clone.data.put(filename, (HashSet)clone.data.get(filename).clone());
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (K key : this.data.keySet()) {
            Iterator<V> valueIt = this.data.get(key).iterator();
            sb.append("(" + key + "," + valueIt.next() + ")");
            while (valueIt.hasNext()) {
                sb.append(", ");
                sb.append("(" + key + "," + valueIt.next() + ")");
            }
        }
        sb.append("]");
        return sb.toString();
    }
}

