/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum CollectionKind implements Enumerator
{
    COLLECTION(0, "Collection", "Collection"),
    SET(1, "Set", "Set"),
    ORDERED_SET(2, "OrderedSet", "OrderedSet"),
    BAG(3, "Bag", "Bag"),
    SEQUENCE(4, "Sequence", "Sequence");

    public static final int COLLECTION_VALUE = 0;
    public static final int SET_VALUE = 1;
    public static final int ORDERED_SET_VALUE = 2;
    public static final int BAG_VALUE = 3;
    public static final int SEQUENCE_VALUE = 4;
    private static final CollectionKind[] VALUES_ARRAY;
    public static final List<CollectionKind> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new CollectionKind[]{COLLECTION, SET, ORDERED_SET, BAG, SEQUENCE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static CollectionKind get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CollectionKind result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CollectionKind getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CollectionKind result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CollectionKind get(int value) {
        switch (value) {
            case 0: {
                return COLLECTION;
            }
            case 1: {
                return SET;
            }
            case 2: {
                return ORDERED_SET;
            }
            case 3: {
                return BAG;
            }
            case 4: {
                return SEQUENCE;
            }
        }
        return null;
    }

    private CollectionKind(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

