/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.bugzilla.core;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.mylyn.internal.bugzilla.core.BugzillaAttribute;
import org.eclipse.mylyn.tasks.core.AbstractTaskListMigrator;
import org.eclipse.mylyn.tasks.core.IRepositoryQuery;
import org.eclipse.mylyn.tasks.core.ITask;
import org.w3c.dom.Element;

public class BugzillaTaskListMigrator
extends AbstractTaskListMigrator {
    private static final String TAG_BUGZILLA_REPORT = "BugzillaReport";
    private static final String KEY_SEVERITY = "bugzilla.severity";
    private static final String KEY_PRODUCT = "bugzilla.product";

    public String getConnectorKind() {
        return "bugzilla";
    }

    public Set<String> getQueryElementNames() {
        HashSet<String> names = new HashSet<String>();
        names.add("BugzillaQuery");
        names.add("BugzillaCustomQuery");
        return names;
    }

    public String getTaskElementName() {
        return TAG_BUGZILLA_REPORT;
    }

    public void migrateQuery(IRepositoryQuery query, Element element) {
        if (element.getNodeName().equals("BugzillaCustomQuery")) {
            query.setAttribute("bugzilla.query.custom", Boolean.TRUE.toString());
        }
    }

    public void migrateTask(ITask task, Element element) {
        if (element.hasAttribute(KEY_SEVERITY)) {
            task.setAttribute(BugzillaAttribute.BUG_SEVERITY.getKey(), element.getAttribute(BugzillaAttribute.BUG_SEVERITY.getKey()));
        }
        if (element.hasAttribute(KEY_PRODUCT)) {
            task.setAttribute(BugzillaAttribute.PRODUCT.getKey(), element.getAttribute(BugzillaAttribute.PRODUCT.getKey()));
        }
        if (element.hasAttribute("LastModified")) {
            task.setAttribute(BugzillaAttribute.DELTA_TS.getKey(), element.getAttribute("LastModified"));
        }
    }
}

