/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.internal.discovery.strategy;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.equinox.internal.p2.discovery.compatibility.ConnectorDiscoveryExtensionReader;
import org.eclipse.equinox.internal.p2.discovery.model.CatalogItem;
import org.eclipse.equinox.internal.p2.discovery.model.FeatureFilter;
import org.eclipse.equinox.internal.p2.discovery.model.Icon;
import org.eclipse.equinox.internal.p2.discovery.model.Overview;
import org.eclipse.equinox.internal.p2.discovery.model.Tag;
import org.eclipse.equinox.internal.p2.discovery.model.ValidationException;
import org.eclipse.m2e.internal.discovery.Messages;

public class M2EConnectorDiscoveryExtensionReader
extends ConnectorDiscoveryExtensionReader {
    private final Map<String, Tag> tagById = new HashMap<String, Tag>();

    public Set<Tag> getTags() {
        return new HashSet<Tag>(this.tagById.values());
    }

    private Tag getTag(String id) {
        if (id == null) {
            return null;
        }
        Tag result = this.tagById.get(id);
        if (result != null) {
            return result;
        }
        Tag[] tagArray = DEFAULT_TAGS;
        int n = DEFAULT_TAGS.length;
        int n2 = 0;
        while (n2 < n) {
            Tag tag = tagArray[n2];
            if (tag.getValue().equals(id)) {
                this.tagById.put(id, tag);
                return tag;
            }
            ++n2;
        }
        result = new Tag(id, id);
        this.tagById.put(id, result);
        return result;
    }

    public <T extends CatalogItem> T readConnectorDescriptor(IConfigurationElement element, Class<T> clazz) throws ValidationException {
        IConfigurationElement child;
        int n;
        CatalogItem connectorDescriptor;
        try {
            connectorDescriptor = (CatalogItem)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        try {
            String kinds = element.getAttribute("kind");
            if (kinds != null) {
                String[] akinds;
                String[] stringArray = akinds = kinds.split("\\s*,\\s*");
                int n2 = akinds.length;
                n = 0;
                while (n < n2) {
                    String kind = stringArray[n];
                    Tag tag = this.getTag(kind);
                    if (tag != null) {
                        connectorDescriptor.addTag(tag);
                    }
                    ++n;
                }
            }
        }
        catch (IllegalArgumentException e) {
            throw new ValidationException(Messages.ConnectorDiscoveryExtensionReader_unexpected_value_kind);
        }
        connectorDescriptor.setName(element.getAttribute("name"));
        connectorDescriptor.setProvider(element.getAttribute("provider"));
        connectorDescriptor.setLicense(element.getAttribute("license"));
        connectorDescriptor.setDescription(element.getAttribute("description"));
        connectorDescriptor.setSiteUrl(element.getAttribute("siteUrl"));
        connectorDescriptor.setId(element.getAttribute("id"));
        connectorDescriptor.setCategoryId(element.getAttribute("categoryId"));
        connectorDescriptor.setCertificationId(element.getAttribute("certificationId"));
        connectorDescriptor.setPlatformFilter(element.getAttribute("platformFilter"));
        connectorDescriptor.setGroupId(element.getAttribute("groupId"));
        IConfigurationElement[] children = element.getChildren("iu");
        if (children.length > 0) {
            IConfigurationElement[] iConfigurationElementArray = children;
            n = children.length;
            int n3 = 0;
            while (n3 < n) {
                child = iConfigurationElementArray[n3];
                connectorDescriptor.getInstallableUnits().add(child.getAttribute("id"));
                ++n3;
            }
        } else {
            connectorDescriptor.getInstallableUnits().add(connectorDescriptor.getId());
        }
        IConfigurationElement[] iConfigurationElementArray = element.getChildren("featureFilter");
        n = iConfigurationElementArray.length;
        int n4 = 0;
        while (n4 < n) {
            child = iConfigurationElementArray[n4];
            FeatureFilter featureFilterItem = this.readFeatureFilter(child);
            featureFilterItem.setItem(connectorDescriptor);
            connectorDescriptor.getFeatureFilter().add(featureFilterItem);
            ++n4;
        }
        iConfigurationElementArray = element.getChildren("icon");
        n = iConfigurationElementArray.length;
        n4 = 0;
        while (n4 < n) {
            child = iConfigurationElementArray[n4];
            Icon iconItem = this.readIcon(child);
            if (connectorDescriptor.getIcon() != null) {
                throw new ValidationException(Messages.ConnectorDiscoveryExtensionReader_unexpected_element_icon);
            }
            connectorDescriptor.setIcon(iconItem);
            ++n4;
        }
        iConfigurationElementArray = element.getChildren("overview");
        n = iConfigurationElementArray.length;
        n4 = 0;
        while (n4 < n) {
            child = iConfigurationElementArray[n4];
            Overview overviewItem = this.readOverview(child);
            overviewItem.setItem(connectorDescriptor);
            if (connectorDescriptor.getOverview() != null) {
                throw new ValidationException(Messages.ConnectorDiscoveryExtensionReader_unexpected_element_overview);
            }
            connectorDescriptor.setOverview(overviewItem);
            ++n4;
        }
        connectorDescriptor.validate();
        return (T)connectorDescriptor;
    }
}

