/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.libra.framework.editor.ui.internal.dependencies;

import java.util.Comparator;
import java.util.List;
import org.eclipse.libra.framework.editor.ui.internal.dependencies.BundleDependencyContentProvider;
import org.eclipse.libra.framework.editor.ui.internal.dependencies.BundleDependencyLayoutAlgorithm;
import org.eclipse.zest.layouts.Filter;
import org.eclipse.zest.layouts.InvalidLayoutConfiguration;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.LayoutEntity;
import org.eclipse.zest.layouts.LayoutRelationship;
import org.eclipse.zest.layouts.algorithms.CompositeLayoutAlgorithm;
import org.eclipse.zest.layouts.progress.ProgressListener;

public class FocusedBundleDependencyLayoutAlgorithm
implements LayoutAlgorithm {
    private final BundleDependencyLayoutAlgorithm focusedLayoutAlgorithm;
    private final CompositeLayoutAlgorithm layoutAlgorithm;
    private final BundleDependencyContentProvider contentProvider;

    public FocusedBundleDependencyLayoutAlgorithm(int styles, CompositeLayoutAlgorithm layoutAlgorithm, BundleDependencyContentProvider contentProvider) {
        this.contentProvider = contentProvider;
        this.layoutAlgorithm = layoutAlgorithm;
        this.focusedLayoutAlgorithm = new BundleDependencyLayoutAlgorithm(contentProvider);
    }

    public void addEntity(LayoutEntity entity) {
        this.layoutAlgorithm.addEntity(entity);
        this.focusedLayoutAlgorithm.addEntity(entity);
    }

    public void addProgressListener(ProgressListener listener) {
        this.layoutAlgorithm.addProgressListener(listener);
        this.focusedLayoutAlgorithm.addProgressListener(listener);
    }

    public void addRelationship(LayoutRelationship relationship) {
        this.layoutAlgorithm.addRelationship(relationship);
        this.focusedLayoutAlgorithm.addRelationship(relationship);
    }

    public void applyLayout(LayoutEntity[] entitiesToLayout, LayoutRelationship[] relationshipsToConsider, double x, double y, double width, double height, boolean asynchronous, boolean continuous) throws InvalidLayoutConfiguration {
        if (this.contentProvider.getContentResult() != null) {
            this.focusedLayoutAlgorithm.applyLayout(entitiesToLayout, relationshipsToConsider, x, y, width, height, asynchronous, continuous);
        } else {
            this.layoutAlgorithm.applyLayout(entitiesToLayout, relationshipsToConsider, x, y, width, height, asynchronous, continuous);
        }
    }

    public double getEntityAspectRatio() {
        return this.layoutAlgorithm.getEntityAspectRatio();
    }

    public int getStyle() {
        return this.layoutAlgorithm.getStyle();
    }

    public boolean isRunning() {
        return this.layoutAlgorithm.isRunning();
    }

    public void removeEntity(LayoutEntity entity) {
        this.layoutAlgorithm.removeEntity(entity);
        this.focusedLayoutAlgorithm.removeEntity(entity);
    }

    public void removeProgressListener(ProgressListener listener) {
        this.layoutAlgorithm.removeProgressListener(listener);
        this.focusedLayoutAlgorithm.removeProgressListener(listener);
    }

    public void removeRelationship(LayoutRelationship relationship) {
        this.layoutAlgorithm.removeRelationship(relationship);
        this.focusedLayoutAlgorithm.removeRelationship(relationship);
    }

    public void removeRelationships(List relationships) {
        this.layoutAlgorithm.removeRelationships(relationships);
        this.focusedLayoutAlgorithm.removeRelationships(relationships);
    }

    public void setComparator(Comparator comparator) {
        this.layoutAlgorithm.setComparator(comparator);
        this.focusedLayoutAlgorithm.setComparator(comparator);
    }

    public void setEntityAspectRatio(double ratio) {
        this.layoutAlgorithm.setEntityAspectRatio(ratio);
        this.focusedLayoutAlgorithm.setEntityAspectRatio(ratio);
    }

    public void setFilter(Filter filter) {
        this.layoutAlgorithm.setFilter(filter);
        this.focusedLayoutAlgorithm.setFilter(filter);
    }

    public void setStyle(int style) {
        this.layoutAlgorithm.setStyle(style);
        this.focusedLayoutAlgorithm.setStyle(style);
    }

    public void stop() {
        this.layoutAlgorithm.stop();
        this.focusedLayoutAlgorithm.stop();
    }
}

