/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.pushstream;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.osgi.util.pushstream.PushEvent;
import org.osgi.util.pushstream.PushbackPolicy;

public enum PushbackPolicyOption {
    FIXED{

        @Override
        public <T, U extends BlockingQueue<PushEvent<? extends T>>> PushbackPolicy<T, U> getPolicy(long value) {
            return q -> value;
        }
    }
    ,
    ON_FULL_FIXED{

        @Override
        public <T, U extends BlockingQueue<PushEvent<? extends T>>> PushbackPolicy<T, U> getPolicy(long value) {
            return q -> q.remainingCapacity() == 0 ? value : 0L;
        }
    }
    ,
    ON_FULL_EXPONENTIAL{

        @Override
        public <T, U extends BlockingQueue<PushEvent<? extends T>>> PushbackPolicy<T, U> getPolicy(long value) {
            AtomicInteger backoffCount = new AtomicInteger(0);
            return q -> {
                if (q.remainingCapacity() == 0) {
                    return value << backoffCount.getAndIncrement();
                }
                backoffCount.set(0);
                return 0L;
            };
        }
    }
    ,
    LINEAR{

        @Override
        public <T, U extends BlockingQueue<PushEvent<? extends T>>> PushbackPolicy<T, U> getPolicy(long value) {
            return q -> {
                long remainingCapacity = q.remainingCapacity();
                long used = q.size();
                return value * used / (used + remainingCapacity);
            };
        }
    };


    private PushbackPolicyOption() {
    }

    public abstract <T, U extends BlockingQueue<PushEvent<? extends T>>> PushbackPolicy<T, U> getPolicy(long var1);

    /* synthetic */ PushbackPolicyOption(String string, int n, PushbackPolicyOption pushbackPolicyOption) {
        this();
    }
}

