/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.primitive;

import java.io.Serializable;
import org.eclipse.collections.api.LazyShortIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.bag.primitive.MutableShortBag;
import org.eclipse.collections.api.block.function.primitive.LongShortToLongFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectShortToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ShortToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.ShortPredicate;
import org.eclipse.collections.api.block.procedure.primitive.ShortProcedure;
import org.eclipse.collections.api.iterator.ShortIterator;
import org.eclipse.collections.api.list.primitive.MutableShortList;
import org.eclipse.collections.api.set.primitive.MutableShortSet;

public class SynchronizedShortIterable
implements ShortIterable,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Object lock;
    private final ShortIterable iterable;

    protected SynchronizedShortIterable(ShortIterable iterable) {
        this(iterable, null);
    }

    protected SynchronizedShortIterable(ShortIterable iterable, Object newLock) {
        if (iterable == null) {
            throw new IllegalArgumentException("Cannot create a SynchronizedShortIterable on a null collection");
        }
        this.iterable = iterable;
        this.lock = newLock == null ? this : newLock;
    }

    public static SynchronizedShortIterable of(ShortIterable iterable) {
        return new SynchronizedShortIterable(iterable);
    }

    public static SynchronizedShortIterable of(ShortIterable iterable, Object lock) {
        return new SynchronizedShortIterable(iterable, lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short[] toArray() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short[] toArray(short[] target) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.toArray(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(short value) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.contains(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(short ... source) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.containsAll(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(ShortIterable source) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.containsAll(source);
        }
    }

    @Override
    public void forEach(ShortProcedure procedure) {
        this.each(procedure);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void each(ShortProcedure procedure) {
        Object object = this.lock;
        synchronized (object) {
            this.iterable.forEach(procedure);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ShortIterable select(ShortPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.select(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ShortIterable reject(ShortPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.reject(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V> RichIterable<V> collect(ShortToObjectFunction<? extends V> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.collect(function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short detectIfNone(ShortPredicate predicate, short ifNone) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.detectIfNone(predicate, ifNone);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int count(ShortPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.count(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean anySatisfy(ShortPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.anySatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean allSatisfy(ShortPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.allSatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean noneSatisfy(ShortPredicate predicate) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.noneSatisfy(predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableShortList toList() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.toList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableShortSet toSet() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.toSet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableShortBag toBag() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.toBag();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LazyShortIterable asLazy() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.asLazy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long sum() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.sum();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short max() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.max();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short maxIfEmpty(short defaultValue) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.maxIfEmpty(defaultValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short min() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.min();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short minIfEmpty(short defaultValue) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.minIfEmpty(defaultValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double average() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.average();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double median() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.median();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public short[] toSortedArray() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.toSortedArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableShortList toSortedList() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.toSortedList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean notEmpty() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.notEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T injectInto(T injectedValue, ObjectShortToObjectFunction<? super T, ? extends T> function) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.injectInto(injectedValue, function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long reduce(LongShortToLongFunction accumulator) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.reduce(accumulator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long reduceIfEmpty(LongShortToLongFunction accumulator, long defaultValue) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.reduceIfEmpty(accumulator, defaultValue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RichIterable<ShortIterable> chunk(int size) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.chunk(size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toString() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String makeString() {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.makeString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String makeString(String separator) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.makeString(separator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String makeString(String start, String separator, String end) {
        Object object = this.lock;
        synchronized (object) {
            return this.iterable.makeString(start, separator, end);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendString(Appendable appendable) {
        Object object = this.lock;
        synchronized (object) {
            this.iterable.appendString(appendable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendString(Appendable appendable, String separator) {
        Object object = this.lock;
        synchronized (object) {
            this.iterable.appendString(appendable, separator);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        Object object = this.lock;
        synchronized (object) {
            this.iterable.appendString(appendable, start, separator, end);
        }
    }

    @Override
    public ShortIterator shortIterator() {
        return this.iterable.shortIterator();
    }
}

