/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.wizards.filewizard;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.cdt.internal.ui.util.NameComposer;
import org.eclipse.cdt.internal.ui.wizards.filewizard.NewFileWizardMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.ui.dialogs.ContainerGenerator;

public class NewSourceFileGenerator {
    public static String generateHeaderFileNameFromClass(String className) {
        IPreferencesService preferences = Platform.getPreferencesService();
        int capitalization = preferences.getInt("org.eclipse.cdt.ui", "nameStyle.cpp.header.capitalization", 0, null);
        String wordDelimiter = preferences.getString("org.eclipse.cdt.ui", "nameStyle.cpp.header.wordDelimiter", "", null);
        String prefix = preferences.getString("org.eclipse.cdt.ui", "nameStyle.cpp.header.prefix", "", null);
        String suffix = preferences.getString("org.eclipse.cdt.ui", "nameStyle.cpp.header.suffix", ".h", null);
        NameComposer composer = new NameComposer(capitalization, wordDelimiter, prefix, suffix);
        return composer.compose(className);
    }

    public static String generateSourceFileNameFromClass(String className) {
        IPreferencesService preferences = Platform.getPreferencesService();
        int capitalization = preferences.getInt("org.eclipse.cdt.ui", "nameStyle.cpp.source.capitalization", 0, null);
        String wordDelimiter = preferences.getString("org.eclipse.cdt.ui", "nameStyle.cpp.source.wordDelimiter", "", null);
        String prefix = preferences.getString("org.eclipse.cdt.ui", "nameStyle.cpp.source.prefix", "", null);
        String suffix = preferences.getString("org.eclipse.cdt.ui", "nameStyle.cpp.source.suffix", ".cpp", null);
        NameComposer composer = new NameComposer(capitalization, wordDelimiter, prefix, suffix);
        return composer.compose(className);
    }

    public static String generateTestFileNameFromClass(String className) {
        IPreferencesService preferences = Platform.getPreferencesService();
        int capitalization = preferences.getInt("org.eclipse.cdt.ui", "nameStyle.cpp.test.capitalization", 0, null);
        String wordDelimiter = preferences.getString("org.eclipse.cdt.ui", "nameStyle.cpp.test.wordDelimiter", "", null);
        String prefix = preferences.getString("org.eclipse.cdt.ui", "nameStyle.cpp.test.prefix", "", null);
        String suffix = preferences.getString("org.eclipse.cdt.ui", "nameStyle.cpp.test.suffix", "_test.cpp", null);
        NameComposer composer = new NameComposer(capitalization, wordDelimiter, prefix, suffix);
        return composer.compose(className);
    }

    public static IFile createHeaderFile(IPath filePath, boolean force, IProgressMonitor monitor) throws CoreException {
        return NewSourceFileGenerator.createEmptyFile(filePath, force, monitor);
    }

    public static IFile createSourceFile(IPath filePath, boolean force, IProgressMonitor monitor) throws CoreException {
        return NewSourceFileGenerator.createEmptyFile(filePath, force, monitor);
    }

    public static IFile createTestFile(IPath filePath, boolean force, IProgressMonitor monitor) throws CoreException {
        return NewSourceFileGenerator.createEmptyFile(filePath, force, monitor);
    }

    public static IFile createEmptyFile(IPath filePath, boolean force, IProgressMonitor monitor) throws CoreException {
        ByteArrayInputStream stream = new ByteArrayInputStream(new byte[0]);
        return NewSourceFileGenerator.createNewFile(filePath, stream, force, monitor);
    }

    private static IFile createNewFile(IPath newFilePath, InputStream contents, boolean force, IProgressMonitor monitor) throws CoreException {
        IPath containerPath;
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)NewFileWizardMessages.NewSourceFileGenerator_createFile_task, (int)100);
        IWorkspaceRoot root = CUIPlugin.getWorkspace().getRoot();
        IFile newFile = root.getFileForLocation(newFilePath);
        if (newFile == null) {
            newFile = root.getFile(newFilePath);
        }
        if (newFile.exists()) {
            return newFile;
        }
        if (newFilePath.segmentCount() > 1 && root.getContainerForLocation(containerPath = newFilePath.removeLastSegments(1)) == null) {
            ContainerGenerator generator = new ContainerGenerator(containerPath);
            generator.generateContainer((IProgressMonitor)subMonitor.split(50));
        }
        NewSourceFileGenerator.createFile(newFile, contents, force, (IProgressMonitor)subMonitor.split(50));
        return newFile;
    }

    private static void createFile(IFile fileHandle, InputStream contents, boolean force, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        if (contents == null) {
            contents = new ByteArrayInputStream(new byte[0]);
        }
        try {
            fileHandle.create(contents, force, (IProgressMonitor)subMonitor.split(1));
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 374) {
                fileHandle.refreshLocal(0, null);
            }
            throw e;
        }
    }
}

