/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.fnmeta.model.util;

import java.io.IOException;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.bpel.common.extension.model.Activator;
import org.eclipse.bpel.fnmeta.model.Argument;
import org.eclipse.bpel.fnmeta.model.Assistant;
import org.eclipse.bpel.fnmeta.model.FMFactory;
import org.eclipse.bpel.fnmeta.model.Function;
import org.eclipse.bpel.fnmeta.model.Option;
import org.eclipse.bpel.fnmeta.model.Optionality;
import org.eclipse.bpel.fnmeta.model.Registry;
import org.eclipse.bpel.fnmeta.model.proxy.ArgumentProxy;
import org.eclipse.bpel.fnmeta.model.proxy.AssistantProxy;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.xmi.XMLDefaultHandler;
import org.eclipse.emf.ecore.xmi.XMLLoad;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class FMReader
implements XMLLoad,
ErrorHandler {
    List<Runnable> fPass2Runnables = new ArrayList<Runnable>();
    DocumentBuilder fBuilder;
    XMLResource fResource;

    public XMLDefaultHandler createDefaultHandler() {
        return null;
    }

    public void load(XMLResource resource, InputStream inputStream, Map<?, ?> options) {
        InputSource inputSource = new InputSource(inputStream);
        inputSource.setPublicId(resource.getURI().toString());
        inputSource.setSystemId(resource.getURI().toString());
        this.load(resource, inputSource, options);
    }

    public void load(XMLResource resource, InputSource inputSource, Map<?, ?> options) {
        Element top = null;
        try {
            top = this.read(inputSource);
        }
        catch (SAXException sAXException) {
        }
        catch (IOException ioe) {
            Activator.log("I/O Error Reading BPEL XML", ioe, 4);
        }
        if (top == null) {
            return;
        }
        this.load(resource, top, options);
    }

    public void load(XMLResource resource, Node node, Map<?, ?> options) {
        if (!(node instanceof Element)) {
            return;
        }
        this.fResource = resource;
        EObject root = this.pass1((Element)node);
        if (root != null) {
            resource.getContents().add((Object)root);
        }
        this.pass2();
    }

    Element read(InputSource inputSource) throws IOException, SAXException {
        if (this.fBuilder == null) {
            this.fBuilder = this.getDocumentBuilder();
            this.fBuilder.setErrorHandler(this);
        }
        return this.fBuilder.parse(inputSource).getDocumentElement();
    }

    protected DocumentBuilder getDocumentBuilder() throws IOException {
        DocumentBuilder builder;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringComments(true);
        factory.setIgnoringElementContentWhitespace(true);
        factory.setValidating(false);
        factory.setNamespaceAware(true);
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException exc) {
            throw new IOException(exc.toString());
        }
        return builder;
    }

    protected EObject pass1(Element elm) {
        return this.xml2Resource(elm);
    }

    protected void pass2() {
        for (Runnable r : this.fPass2Runnables) {
            r.run();
        }
        this.fPass2Runnables.clear();
    }

    protected List<Element> getChildElements(Element parentElement) {
        ArrayList<Element> list = new ArrayList<Element>();
        NodeList children = parentElement.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            if (children.item(i).getNodeType() == 1) {
                list.add((Element)children.item(i));
            }
            ++i;
        }
        return list;
    }

    protected List<Element> getChildElementsByLocalName(Element parentElement, String localName) {
        ArrayList<Element> list = new ArrayList<Element>();
        Node node = parentElement.getFirstChild();
        while (node != null) {
            if (localName.equals(node.getLocalName())) {
                list.add((Element)node);
            }
            node = node.getNextSibling();
        }
        return list;
    }

    protected Element getChildElementByLocalName(Element parentElement, String localName) {
        Node node = parentElement.getFirstChild();
        while (node != null) {
            if (localName.equals(node.getLocalName())) {
                return (Element)node;
            }
            node = node.getNextSibling();
        }
        return null;
    }

    protected EObject xml2Resource(Element element) {
        return this.xml2Registry(element);
    }

    protected Registry xml2Registry(Element element) {
        if (element == null || !element.getLocalName().equals("bpel-xpath-functions")) {
            return null;
        }
        Registry registry = FMFactory.eINSTANCE.createRegistry();
        registry.setElement(element);
        for (Element e : this.getChildElementsByLocalName(element, "assistant")) {
            registry.getAssistants().add((Object)this.xml2Assistant(e));
        }
        for (Element e : this.getChildElementsByLocalName(element, "arg")) {
            registry.getArguments().add((Object)this.xml2Argument(e));
        }
        for (Element e : this.getChildElementsByLocalName(element, "function")) {
            registry.getFunctions().add((Object)this.xml2Function(e));
        }
        return registry;
    }

    protected Assistant xml2Assistant(Element element) {
        if (element == null || !element.getLocalName().equals("assistant")) {
            return null;
        }
        if (element.getFirstChild() == null || element.hasAttribute("ref")) {
            return new AssistantProxy(this.fResource.getURI(), element.getAttribute("ref"));
        }
        Assistant assistant = FMFactory.eINSTANCE.createAssistant();
        for (Element e : this.getChildElementsByLocalName(element, "option")) {
            assistant.getOptions().add((Object)this.xml2Option(e));
        }
        return assistant;
    }

    protected Option xml2Option(Element element) {
        if (element == null || !element.getLocalName().equals("option")) {
            return null;
        }
        Option option = FMFactory.eINSTANCE.createOption();
        option.setValue(element.getAttribute("value"));
        option.setDisplayValue(this.getText(element));
        return option;
    }

    protected Argument xml2Argument(Element element) {
        if (element == null || !element.getLocalName().equals("arg")) {
            return null;
        }
        if (element.getFirstChild() == null || element.hasAttribute("ref")) {
            return new ArgumentProxy(this.fResource.getURI(), element.getAttribute("ref"));
        }
        Argument arg = FMFactory.eINSTANCE.createArgument();
        arg.setElement(element);
        arg.setName(element.getAttribute("name"));
        arg.setType(element.getAttribute("type"));
        arg.setDefaultValue(element.getAttribute("default"));
        String opt = element.getAttribute("optional");
        if ("true".equalsIgnoreCase(opt) || "?".equals(opt)) {
            arg.setOptionality(Optionality.OPTIONAL);
        } else if ("*".equals(opt)) {
            arg.setOptionality(Optionality.OPTIONAL_MANY);
        }
        arg.setAssistant(this.xml2Assistant(this.getChildElementByLocalName(element, "assistant")));
        arg.setComment(this.getText(this.getChildElementByLocalName(element, "comment")));
        return arg;
    }

    protected Function xml2Function(Element element) {
        Element ns;
        if (element == null || !element.getLocalName().equals("function")) {
            return null;
        }
        Function function = FMFactory.eINSTANCE.createFunction();
        function.setElement(element);
        function.setName(element.getAttribute("id"));
        function.setReturnType(element.getAttribute("returns"));
        function.setHelp(this.getText(this.getChildElementByLocalName(element, "help")));
        function.setComment(this.getText(this.getChildElementByLocalName(element, "comment")));
        function.setClassName(element.getAttribute("class"));
        Element dep = this.getChildElementByLocalName(element, "deprecated");
        if (dep != null) {
            function.setIsDeprecated(false);
            function.setDeprecateComment(this.getText(dep));
        }
        if ((ns = this.getChildElementByLocalName(element, "namespace")) != null) {
            function.setNamespace(this.getText(ns));
            function.setPrefix(ns.getAttribute("prefix"));
        }
        for (Element a : this.getChildElementsByLocalName(element, "arg")) {
            function.getArguments().add((Object)this.xml2Argument(a));
        }
        return function;
    }

    public static boolean isEmptyOrWhitespace(String value) {
        if (value == null || value.length() == 0) {
            return true;
        }
        int i = 0;
        int j = value.length();
        while (i < j) {
            if (!Character.isWhitespace(value.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    String getText(Node node) {
        StringBuilder sb = new StringBuilder(128);
        if (node instanceof Element) {
            node = ((Element)node).getFirstChild();
        }
        boolean bCData = false;
        while (node != null) {
            switch (node.getNodeType()) {
                case 3: {
                    if (bCData) break;
                    Text text = (Text)node;
                    sb.append(text.getData());
                    break;
                }
                case 4: {
                    if (!bCData) {
                        sb.setLength(0);
                        bCData = true;
                    }
                    CDATASection cdata = (CDATASection)node;
                    sb.append(cdata.getData());
                }
            }
            node = node.getNextSibling();
        }
        String data = sb.toString();
        if (FMReader.isEmptyOrWhitespace(data)) {
            return null;
        }
        return data;
    }

    @Override
    public void error(SAXParseException exception) {
        String message = MessageFormat.format("Error in {0} [{2}:{3}] {4}", exception.getPublicId(), exception.getSystemId(), exception.getLineNumber(), exception.getColumnNumber(), exception.getLocalizedMessage());
        Activator.log(message, exception, 4);
    }

    @Override
    public void fatalError(SAXParseException exception) {
        String message = MessageFormat.format("Fatal Error in {0} [{2}:{3}] {4}", exception.getPublicId(), exception.getSystemId(), exception.getLineNumber(), exception.getColumnNumber(), exception.getLocalizedMessage());
        Activator.log(message, exception, 4);
    }

    @Override
    public void warning(SAXParseException exception) {
        String message = MessageFormat.format("Warning in {0} [{2}:{3}] {4}", exception.getPublicId(), exception.getSystemId(), exception.getLineNumber(), exception.getColumnNumber(), exception.getLocalizedMessage());
        Activator.log(message, exception, 2);
    }
}

