/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.core.annotations;

import com.google.common.collect.RangeSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.annotations.Annotation;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.annotations.AnnotationCategoriesModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.annotations.AnnotationModel;
import org.eclipse.tracecompass.internal.provisional.tmf.core.model.annotations.IOutputAnnotationProvider;
import org.eclipse.tracecompass.internal.tmf.core.annotations.PeriodicAnnotationProvider;
import org.eclipse.tracecompass.internal.tmf.core.markers.IMarkerConstants;
import org.eclipse.tracecompass.internal.tmf.core.markers.Marker;
import org.eclipse.tracecompass.internal.tmf.core.markers.MarkerSegment;
import org.eclipse.tracecompass.internal.tmf.core.markers.MarkerSet;
import org.eclipse.tracecompass.internal.tmf.core.markers.SubMarker;
import org.eclipse.tracecompass.tmf.core.dataprovider.DataProviderParameterUtils;
import org.eclipse.tracecompass.tmf.core.dataprovider.X11ColorUtils;
import org.eclipse.tracecompass.tmf.core.markers.ITimeReference;
import org.eclipse.tracecompass.tmf.core.markers.ITimeReferenceProvider;
import org.eclipse.tracecompass.tmf.core.markers.TimeReference;
import org.eclipse.tracecompass.tmf.core.model.OutputElementStyle;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;
import org.eclipse.tracecompass.tmf.core.response.ITmfResponse;
import org.eclipse.tracecompass.tmf.core.response.TmfModelResponse;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class CustomAnnotationProvider
implements IOutputAnnotationProvider {
    private static final String DEFAULT_COLOR = "blue";
    private static final long MIN_PERIOD = 5L;
    private static final int ALPHA = 10;
    private static final String COLOR_REGEX = "#[A-Fa-f0-9]{6}";
    private List<CustomPeriodicAnnotationProvider> fAnnotationProviders = new ArrayList<CustomPeriodicAnnotationProvider>();
    private Map<Marker, RGBAColor> fColors = new HashMap<Marker, RGBAColor>();
    private final @Nullable ITmfTrace fTrace;
    private @Nullable MarkerSet fMarkerSet;

    public CustomAnnotationProvider(@Nullable ITmfTrace trace, @Nullable MarkerSet markerSet) {
        this.fTrace = trace;
        this.fMarkerSet = markerSet;
        this.fAnnotationProviders = this.configure(markerSet);
    }

    public List<CustomPeriodicAnnotationProvider> configure(@Nullable MarkerSet markerSet) {
        ArrayList<CustomPeriodicAnnotationProvider> annotationProviders = new ArrayList<CustomPeriodicAnnotationProvider>();
        if (markerSet != null) {
            for (Marker marker : markerSet.getMarkers()) {
                annotationProviders.add(this.configure(Objects.requireNonNull(marker)));
            }
        }
        this.fAnnotationProviders = annotationProviders;
        this.fMarkerSet = markerSet;
        return annotationProviders;
    }

    private CustomPeriodicAnnotationProvider configure(Marker marker) {
        if (marker instanceof Marker.PeriodicMarker) {
            ITimeReferenceProvider adapter;
            Marker.PeriodicMarker periodicMarker = (Marker.PeriodicMarker)marker;
            long rollover = periodicMarker.getRange().hasUpperBound() ? (Long)periodicMarker.getRange().upperEndpoint() - (Long)periodicMarker.getRange().lowerEndpoint() + 1L : 0L;
            RGBAColor evenColor = this.getColor(marker);
            RGBAColor oddColor = CustomAnnotationProvider.getOddColor(evenColor);
            ITmfTrace trace = this.fTrace;
            double period = IMarkerConstants.convertToNanos(periodicMarker.getPeriod(), periodicMarker.getUnit(), trace);
            String referenceId = periodicMarker.getReferenceId();
            ITimeReference baseReference = null;
            if (trace instanceof IAdaptable && !referenceId.isEmpty() && (adapter = (ITimeReferenceProvider)((IAdaptable)trace).getAdapter(ITimeReferenceProvider.class)) != null) {
                baseReference = adapter.apply(referenceId);
            }
            if (baseReference == null) {
                baseReference = ITimeReference.ZERO;
            }
            TimeReference reference = new TimeReference(baseReference.getTime() + Math.round(IMarkerConstants.convertToNanos(periodicMarker.getOffset(), periodicMarker.getUnit(), trace)), baseReference.getIndex());
            return new CustomPeriodicAnnotationProvider(periodicMarker, reference, period, rollover, evenColor, oddColor);
        }
        throw new IllegalArgumentException("Marker must be of type PeriodicMarker or SubMarker");
    }

    private void getSubMarkerList(SubMarker subMarker, Annotation markerEvent, Map<String, Collection<@NonNull Annotation>> markerMap, long startTime, long endTime, long minDuration, Long[] times) {
        if (subMarker instanceof SubMarker.SplitMarker) {
            this.getSubMarkerList((SubMarker.SplitMarker)subMarker, markerEvent, markerMap, startTime, endTime, minDuration, times);
        } else if (subMarker instanceof SubMarker.WeightedMarker) {
            this.getSubMarkerList((SubMarker.WeightedMarker)subMarker, markerEvent, markerMap, startTime, endTime, minDuration, times);
        }
    }

    private void getSubMarkerList(SubMarker.SplitMarker splitMarker, Annotation markerEvent, Map<String, Collection<@NonNull Annotation>> annotationMap, long startTime, long endTime, long minDuration, Long[] times) {
        if (markerEvent.getTime() > endTime || markerEvent.getTime() + markerEvent.getDuration() < startTime) {
            return;
        }
        long lower = (Long)splitMarker.getRange().lowerEndpoint();
        long upper = (Long)splitMarker.getRange().upperEndpoint();
        long segments = upper - lower + 1L;
        long start = markerEvent.getTime();
        ArrayList<@NonNull Annotation> annotationList = new ArrayList<Annotation>();
        int i = 0;
        while ((long)i < segments) {
            long end = markerEvent.getTime() + Math.round((double)(i + 1) / (double)segments * (double)markerEvent.getDuration());
            long duration = end - start;
            long labelIndex = lower + (long)i;
            if (end >= startTime && duration > minDuration && splitMarker.getIndexRange().contains((Comparable)Long.valueOf(labelIndex))) {
                RGBAColor color = (labelIndex & 1L) == 0L ? this.getColor(splitMarker) : CustomAnnotationProvider.getOddColor(this.getColor(splitMarker));
                OutputElementStyle outputStyle = CustomAnnotationProvider.getOutputStyle(color);
                Annotation subAnnotation = new Annotation(start, end - start, -1L, String.format(splitMarker.getLabel(), labelIndex), outputStyle);
                for (SubMarker subMarker : splitMarker.getSubMarkers()) {
                    this.getSubMarkerList(Objects.requireNonNull(subMarker), subAnnotation, annotationMap, startTime, endTime, minDuration, times);
                }
                annotationList.add(subAnnotation);
            }
            if (start >= endTime) break;
            start = end;
            ++i;
        }
        CustomAnnotationProvider.populateMap(annotationMap, annotationList, Objects.requireNonNull(splitMarker.getName()));
    }

    private void getSubMarkerList(SubMarker.WeightedMarker weightedMarker, Annotation markerEvent, Map<String, Collection<@NonNull Annotation>> annotationMap, long startTime, long endTime, long minDuration, Long[] times) {
        if (markerEvent.getTime() > endTime || markerEvent.getTime() + markerEvent.getDuration() < startTime) {
            return;
        }
        long start = markerEvent.getTime();
        long length = 0L;
        ArrayList<@NonNull Annotation> annotationsList = new ArrayList<Annotation>();
        int i = 0;
        while (i < weightedMarker.getSegments().size()) {
            MarkerSegment segment = weightedMarker.getSegments().get(i);
            long end = markerEvent.getTime() + Math.round((double)(length += (long)segment.getLength()) / (double)weightedMarker.getTotalLength() * (double)markerEvent.getDuration());
            long duration = end - start;
            if (end >= startTime && duration > minDuration && !segment.getColor().isEmpty()) {
                RGBAColor color = this.getColor(segment);
                Annotation subAnnotation = new Annotation(start, end - start, -1L, String.format(segment.getLabel(), i), CustomAnnotationProvider.getOutputStyle(color));
                for (SubMarker subMarker : segment.getSubMarkers()) {
                    this.getSubMarkerList(Objects.requireNonNull(subMarker), subAnnotation, annotationMap, startTime, endTime, minDuration, times);
                }
                for (SubMarker subMarker : weightedMarker.getSubMarkers()) {
                    this.getSubMarkerList(Objects.requireNonNull(subMarker), subAnnotation, annotationMap, startTime, endTime, minDuration, times);
                }
                annotationsList.add(subAnnotation);
            }
            if (start >= endTime) break;
            start = end;
            ++i;
        }
        CustomAnnotationProvider.populateMap(annotationMap, annotationsList, Objects.requireNonNull(weightedMarker.getName()));
    }

    private static void populateMap(Map<String, Collection<@NonNull Annotation>> annotationMap, List<@NonNull Annotation> annotationsList, String name) {
        Collection<@NonNull Annotation> annotations = annotationMap.get(name);
        if (annotations != null) {
            annotations.addAll(annotationsList);
        } else {
            annotationMap.put(name, annotationsList);
        }
    }

    private RGBAColor getColor(Marker marker) {
        RGBAColor color = this.fColors.get(marker);
        if (color == null) {
            color = CustomAnnotationProvider.parseColor(marker.getColor());
            this.fColors.put(marker, color);
        }
        return color;
    }

    private static RGBAColor getOddColor(RGBAColor color) {
        return new RGBAColor(color.getRed(), color.getGreen(), color.getBlue(), 0);
    }

    private static RGBAColor fromHexColor(@Nullable String color) {
        if (color != null && color.matches(COLOR_REGEX)) {
            return new RGBAColor(Integer.valueOf(color.substring(1, 3), 16), Integer.valueOf(color.substring(3, 5), 16), Integer.valueOf(color.substring(5, 7), 16), 10);
        }
        return new RGBAColor(0, 0, 0, 10);
    }

    private static RGBAColor parseColor(@Nullable String colorString) {
        if (colorString == null) {
            return CustomAnnotationProvider.fromHexColor(DEFAULT_COLOR);
        }
        if (colorString.matches(COLOR_REGEX)) {
            return CustomAnnotationProvider.fromHexColor(colorString);
        }
        return CustomAnnotationProvider.fromHexColor(X11ColorUtils.toHexColor(colorString));
    }

    private Map<@NonNull String, @NonNull Collection<@NonNull Annotation>> getMarkers(Map<@NonNull String, @NonNull Object> fetchParams, @Nullable IProgressMonitor monitor) {
        List<@NonNull Long> timeRequested = DataProviderParameterUtils.extractTimeRequested(fetchParams);
        if (timeRequested == null || timeRequested.size() < 2) {
            return Collections.emptyMap();
        }
        Long[] times = timeRequested.toArray(new Long[0]);
        long starttime = timeRequested.get(0);
        long endtime = timeRequested.get(timeRequested.size() - 1);
        int resolution = (int)Math.min(Integer.MAX_VALUE, timeRequested.get(1) - timeRequested.get(0));
        LinkedHashMap<@NonNull String, @NonNull Collection<@NonNull Annotation>> markerMap = new LinkedHashMap<String, Collection<Annotation>>();
        for (CustomPeriodicAnnotationProvider periodicAnnotationProvider : this.fAnnotationProviders) {
            AnnotationModel model;
            long minDuration = (long)resolution * 5L;
            long maxDuration = (long)periodicAnnotationProvider.getPeriod();
            if (maxDuration <= minDuration || (model = periodicAnnotationProvider.fetchAnnotations(fetchParams, monitor).getModel()) == null) continue;
            Map<@NonNull String, @NonNull Collection<@NonNull Annotation>> annotations = model.getAnnotations();
            ArrayList<Annotation> markerList = new ArrayList<Annotation>();
            for (Map.Entry<String, Collection<Annotation>> entryAnnotation : annotations.entrySet()) {
                String category = Objects.requireNonNull(entryAnnotation.getKey());
                for (Annotation annotation : Objects.requireNonNull(entryAnnotation.getValue())) {
                    markerList.add(annotation);
                    for (SubMarker subMarker : periodicAnnotationProvider.getSubMarkers()) {
                        this.getSubMarkerList(Objects.requireNonNull(subMarker), annotation, markerMap, starttime, endtime, minDuration, times);
                    }
                }
                markerMap.put(category, markerList);
            }
        }
        @Nullable Set<@NonNull String> categoriesRequested = DataProviderParameterUtils.extractSelectedCategories(fetchParams);
        markerMap.keySet().removeIf(cat -> categoriesRequested != null && !categoriesRequested.contains(cat));
        return markerMap;
    }

    private static OutputElementStyle getOutputStyle(RGBAColor color) {
        HashMap<@NonNull String, @NonNull Object> style = new HashMap<String, Object>();
        String colorString = color.toString().substring(0, 7);
        style.put("style-name", colorString);
        style.put("color", colorString);
        style.put("opacity", Float.valueOf((float)((double)color.getAlpha() / 255.0)));
        return new OutputElementStyle(null, style);
    }

    @Override
    public @NonNull TmfModelResponse<@NonNull AnnotationCategoriesModel> fetchAnnotationCategories(@NonNull Map<@NonNull String, @NonNull Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        LinkedHashSet<@NonNull String> categories = new LinkedHashSet<String>();
        for (CustomPeriodicAnnotationProvider annotationProvider : this.fAnnotationProviders) {
            TmfModelResponse<@NonNull AnnotationCategoriesModel> response = annotationProvider.fetchAnnotationCategories(fetchParameters, monitor);
            AnnotationCategoriesModel model = response.getModel();
            if (model == null) continue;
            categories.addAll(model.getAnnotationCategories());
            this.getSubMarkerCategories(categories, annotationProvider.getSubMarkers());
        }
        return new TmfModelResponse<AnnotationCategoriesModel>(new AnnotationCategoriesModel(new ArrayList<String>(categories)), ITmfResponse.Status.COMPLETED, "");
    }

    private void getSubMarkerCategories(Set<String> categories, List<SubMarker> subMarkers) {
        for (SubMarker subMarker : subMarkers) {
            categories.add(subMarker.getName());
            this.getSubMarkerCategories(categories, subMarker.getSubMarkers());
            if (!(subMarker instanceof SubMarker.WeightedMarker)) continue;
            for (MarkerSegment segment : ((SubMarker.WeightedMarker)subMarker).getSegments()) {
                this.getSubMarkerCategories(categories, segment.getSubMarkers());
            }
        }
    }

    @Override
    public @NonNull TmfModelResponse<@NonNull AnnotationModel> fetchAnnotations(@NonNull Map<@NonNull String, @NonNull Object> fetchParameters, @Nullable IProgressMonitor monitor) {
        Map<@NonNull String, @NonNull Collection<@NonNull Annotation>> markers = this.getMarkers(fetchParameters, monitor);
        return new TmfModelResponse<AnnotationModel>(new AnnotationModel(markers), ITmfResponse.Status.COMPLETED, "");
    }

    public double getMaxDuration() {
        double duration = 0.0;
        for (IOutputAnnotationProvider iOutputAnnotationProvider : this.fAnnotationProviders) {
            if (!(iOutputAnnotationProvider instanceof PeriodicAnnotationProvider)) continue;
            duration = Math.max(duration, ((PeriodicAnnotationProvider)iOutputAnnotationProvider).getPeriod());
        }
        return duration;
    }

    public Map<String, String> getLabel() {
        HashMap<String, String> labels = new HashMap<String, String>();
        if (this.fMarkerSet != null) {
            for (Marker marker : this.fMarkerSet.getMarkers()) {
                if (!(marker instanceof Marker.PeriodicMarker)) continue;
                Marker.PeriodicMarker periodicMarker = (Marker.PeriodicMarker)marker;
                labels.put(Objects.requireNonNull(periodicMarker.getName()), Objects.requireNonNull(periodicMarker.getLabel()));
            }
        }
        return labels;
    }

    private class CustomPeriodicAnnotationProvider
    extends PeriodicAnnotationProvider {
        private final long fStartIndex;
        private final String fLabel;
        private final RangeSet<Long> fIndexRange;
        private List<SubMarker> fSubMarkers;

        public CustomPeriodicAnnotationProvider(Marker.PeriodicMarker periodicMarker, ITimeReference reference, double period, long rollover, RGBAColor evenColor, RGBAColor oddColor) {
            super(periodicMarker.getName(), reference, period, rollover, evenColor, oddColor);
            this.fStartIndex = (Long)periodicMarker.getRange().lowerEndpoint();
            this.fLabel = periodicMarker.getLabel();
            this.fIndexRange = periodicMarker.getIndexRange();
            this.fSubMarkers = periodicMarker.getSubMarkers();
        }

        @Override
        public String getAnnotationLabel(long index) {
            return (String)NonNullUtils.checkNotNull((Object)String.format(this.fLabel, this.fStartIndex + index));
        }

        @Override
        public boolean isApplicable(long index) {
            if (this.fIndexRange != null) {
                return this.fIndexRange.contains((Comparable)Long.valueOf(this.fStartIndex + index));
            }
            return true;
        }

        public List<SubMarker> getSubMarkers() {
            return this.fSubMarkers;
        }
    }
}

