/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.controls.validator;

import org.eclipse.tcf.te.ui.controls.validator.NumberValidator;

public class PortNumberValidator
extends NumberValidator {
    public static final String PORT_REGEX_DEC = "([0-9]{1,5})";
    public static final String PORT_REGEX_HEX = "(0(x|X)[0-9a-fA-F]{1,4})";
    public static final int ATTR_HEX = 4;
    public static final int ATTR_DECIMAL = 8;

    public PortNumberValidator() {
        this(9);
    }

    public PortNumberValidator(int attributes) {
        this(attributes, 0, 65535);
    }

    public PortNumberValidator(int attributes, int min, int max) {
        super(attributes, PortNumberValidator.getRegEx(attributes), min, max);
        this.setMessageText("RegexValidator_Information_MissingValue", this.getString("PortNumberValidator_Information_MissingPortNumber"));
        this.setMessageText("RegexValidator_Error_InvalidValue", this.getString("PortNumberValidator_Error_InvalidPortNumber"));
        this.setMessageText("NumberValidator_Error_InvalidRange", this.getString("PortNumberValidator_Error_PortNumberNotInRange"));
    }

    private static String getRegEx(int attributes) {
        String regex = null;
        if (PortNumberValidator.isAttribute(8, attributes) || !PortNumberValidator.isAttribute(4, attributes)) {
            regex = PORT_REGEX_DEC;
        }
        if (PortNumberValidator.isAttribute(4, attributes) || !PortNumberValidator.isAttribute(8, attributes)) {
            regex = regex != null ? String.valueOf(regex) + "|" + PORT_REGEX_HEX : PORT_REGEX_HEX;
        }
        return regex;
    }
}

