/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.base.io;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.eclipse.passage.lic.api.LicensingException;
import org.eclipse.passage.lic.base.io.PassageFileExtension;
import org.eclipse.passage.lic.internal.base.i18n.BaseMessages;

public final class Settings {
    private final Supplier<Path> base;
    private final Predicate<Map<String, Object>> enough;

    public Settings(Supplier<Path> base, Predicate<Map<String, Object>> enough) {
        this.base = base;
        this.enough = enough;
    }

    public Settings(Supplier<Path> base) {
        this(base, map -> false);
    }

    public Map<String, Object> get() throws LicensingException {
        HunterForSettingsFiles hunter = new HunterForSettingsFiles();
        try {
            Files.walkFileTree(this.base.get(), hunter);
        }
        catch (IOException e) {
            throw new LicensingException(BaseMessages.getString("Settings.error_on_reading_settings"), (Throwable)e);
        }
        return hunter.findings();
    }

    private final class HunterForSettingsFiles
    extends SimpleFileVisitor<Path> {
        private final Map<String, Object> properties;
        private final PassageFileExtension extension = new PassageFileExtension.Settings();

        public HunterForSettingsFiles() {
            this.properties = new HashMap<String, Object>();
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (!this.extension.ends(file)) {
                return FileVisitResult.CONTINUE;
            }
            this.load(file).stream().forEach(e -> {
                Object object = this.properties.put(e.getKey().toString(), e.getValue());
            });
            return Settings.this.enough.test(this.properties) ? FileVisitResult.TERMINATE : FileVisitResult.CONTINUE;
        }

        private Set<Map.Entry<Object, Object>> load(Path file) throws IOException {
            Properties heap = new Properties();
            Throwable throwable = null;
            Object var4_5 = null;
            try (FileInputStream stream = new FileInputStream(file.toFile());){
                heap.load(stream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return heap.entrySet();
        }

        Map<String, Object> findings() {
            return this.properties;
        }
    }
}

