/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.delegate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.common.delegate.VirtualDelegateMapping;
import org.eclipse.ocl.pivot.internal.delegate.AbstractDelegatedBehavior;
import org.eclipse.ocl.pivot.internal.delegate.DelegateDomain;
import org.eclipse.ocl.pivot.internal.delegate.DelegatedBehavior;
import org.eclipse.ocl.pivot.internal.delegate.OCLDelegateDomain;
import org.eclipse.ocl.pivot.internal.delegate.OCLDelegateDomainFactory;
import org.eclipse.ocl.pivot.utilities.ClassUtil;

public class DelegateEPackageAdapter
extends AdapterImpl {
    protected Map<String, DelegateDomain> delegateDomainMap = null;

    public static @Nullable DelegateEPackageAdapter findAdapter(@NonNull EPackage ePackage) {
        return (DelegateEPackageAdapter)EcoreUtil.getAdapter((List)ePackage.eAdapters(), DelegateEPackageAdapter.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static @NonNull DelegateEPackageAdapter getAdapter(@NonNull EPackage ePackage) {
        DelegateEPackageAdapter adapter;
        EList eAdapters;
        EList eList = eAdapters = ePackage.eAdapters();
        synchronized (eList) {
            adapter = (DelegateEPackageAdapter)EcoreUtil.getAdapter((List)eAdapters, DelegateEPackageAdapter.class);
            if (adapter == null) {
                adapter = new DelegateEPackageAdapter();
                eAdapters.add((Object)adapter);
            }
        }
        return adapter;
    }

    protected @NonNull DelegateDomain createDelegateDomain(@NonNull String delegateURI) {
        Class<DelegateDomain.Factory.Registry> castClass;
        EPackage ePackage = ClassUtil.nonNullState(this.getTarget());
        @NonNull DelegateDomain.Factory.Registry registry = OCLDelegateDomain.getDelegateResourceSetRegistry((EModelElement)ePackage, castClass = DelegateDomain.Factory.Registry.class, DelegateDomain.Factory.Registry.INSTANCE);
        DelegateDomain.Factory factory = registry.getFactory(delegateURI);
        if (factory == null) {
            factory = OCLDelegateDomainFactory.INSTANCE;
        }
        return factory.createDelegateDomain(delegateURI, ePackage);
    }

    public @NonNull Collection<DelegateDomain> getAllDelegateDomains() {
        if (this.delegateDomainMap == null) {
            this.getDelegateDomains();
        }
        return this.delegateDomainMap.values();
    }

    public @Nullable DelegateDomain getDelegateDomain(@NonNull String delegateURI) {
        if (this.delegateDomainMap == null) {
            this.getDelegateDomains();
        }
        return this.delegateDomainMap.get(delegateURI);
    }

    public synchronized @NonNull Map<String, DelegateDomain> getDelegateDomains() {
        Map<String, DelegateDomain> delegateDomainMap2 = this.delegateDomainMap;
        if (delegateDomainMap2 == null) {
            this.delegateDomainMap = delegateDomainMap2 = new HashMap<String, DelegateDomain>();
            EPackage ePackage = this.getTarget();
            EAnnotation eAnnotation = ePackage.getEAnnotation("http://www.eclipse.org/emf/2002/Ecore");
            if (eAnnotation != null) {
                VirtualDelegateMapping registry = VirtualDelegateMapping.getRegistry((EModelElement)ePackage);
                EMap details = eAnnotation.getDetails();
                for (DelegatedBehavior<?, ?, ?> delegatedBehavior : AbstractDelegatedBehavior.getDelegatedBehaviors()) {
                    String behaviorName = delegatedBehavior.getName();
                    String delegateURIs = (String)details.get((Object)behaviorName);
                    if (delegateURIs == null) continue;
                    StringTokenizer stringTokenizer = new StringTokenizer(delegateURIs);
                    while (stringTokenizer.hasMoreTokens()) {
                        @NonNull String delegateURI = stringTokenizer.nextToken();
                        @NonNull String resolvedURI = registry.resolve(delegateURI);
                        this.loadDelegateDomain(resolvedURI);
                    }
                }
            }
        }
        return delegateDomainMap2;
    }

    public EPackage getTarget() {
        return (EPackage)super.getTarget();
    }

    public boolean isAdapterForType(Object type) {
        return type == DelegateEPackageAdapter.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @NonNull DelegateDomain loadDelegateDomain(@NonNull String delegateURI) {
        DelegateDomain delegateDomain;
        if (this.delegateDomainMap == null) {
            this.getDelegateDomains();
        }
        if ((delegateDomain = this.delegateDomainMap.get(delegateURI)) == null) {
            Map<String, DelegateDomain> map = this.delegateDomainMap;
            synchronized (map) {
                delegateDomain = this.delegateDomainMap.get(delegateURI);
                if (delegateDomain == null) {
                    delegateDomain = this.createDelegateDomain(delegateURI);
                    this.delegateDomainMap.put(delegateURI, delegateDomain);
                }
            }
        }
        return delegateDomain;
    }

    public void setTarget(Notifier newTarget) {
        EPackage resourceSet = (EPackage)newTarget;
        super.setTarget((Notifier)resourceSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unloadDelegates() {
        if (this.delegateDomainMap != null) {
            ArrayList<DelegateDomain> delegateDomains;
            Map<String, DelegateDomain> map = this.delegateDomainMap;
            synchronized (map) {
                delegateDomains = new ArrayList<DelegateDomain>(this.delegateDomainMap.values());
            }
            for (DelegateDomain delegateDomain : delegateDomains) {
                delegateDomain.reset();
            }
        }
    }

    public void unsetTarget(Notifier oldTarget) {
        super.unsetTarget(oldTarget);
        this.unloadDelegates();
    }
}

