/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.itcl.internal.core.parser.processors;

import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.compiler.problem.ProblemSeverities;
import org.eclipse.dltk.itcl.internal.core.parser.ast.IncrTclConfigBody;
import org.eclipse.dltk.itcl.internal.core.parser.processors.IncrTclUtils;
import org.eclipse.dltk.tcl.ast.TclStatement;
import org.eclipse.dltk.tcl.core.AbstractTclCommandProcessor;
import org.eclipse.dltk.tcl.core.ITclParser;

public class IncrTclConfigBodyCommandProcessor
extends AbstractTclCommandProcessor {
    public ASTNode process(TclStatement statement, ITclParser parser, ASTNode parent) {
        if (statement == null || statement != null && statement.getCount() == 0) {
            return null;
        }
        if (statement.getCount() < 3) {
            this.report(parser, "Wrong number of arguments", statement.sourceStart(), statement.sourceEnd(), ProblemSeverities.Error);
            this.addToParent(parent, (ASTNode)statement);
            return statement;
        }
        Expression procName = statement.getAt(1);
        String sName = IncrTclUtils.extractMethodName(procName);
        if (sName == null || sName.length() == 0) {
            this.report(parser, "Wrong number of arguments", statement.sourceStart(), statement.sourceEnd(), ProblemSeverities.Error);
            this.addToParent(parent, (ASTNode)statement);
            return statement;
        }
        Expression procCode = statement.getAt(2);
        IncrTclConfigBody configBody = new IncrTclConfigBody(statement.sourceStart(), statement.sourceEnd());
        configBody.setName(sName);
        configBody.setNameStart(procName.sourceStart());
        configBody.setNameEnd(procName.sourceEnd());
        Block block = new Block(procCode.sourceStart(), procCode.sourceEnd());
        configBody.acceptBody(block);
        IncrTclUtils.parseAddToBlock(parser, procCode, block);
        configBody.setModifier(0x400000);
        this.addToParent(parent, (ASTNode)configBody);
        return configBody;
    }
}

