/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.tests.harness;

import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.tests.harness.CoreTest;
import org.eclipse.test.performance.Dimension;
import org.eclipse.test.performance.Performance;
import org.eclipse.test.performance.PerformanceMeter;

public abstract class PerformanceTestRunner {
    private String regressionReason;
    private String fingerprintName;

    public void setRegressionReason(String comment) {
        this.regressionReason = comment;
    }

    protected abstract void test();

    public final void run(TestCase testCase, int outer, int inner) {
        this.run(testCase, null, outer, inner);
    }

    public final void run(TestCase testCase, String localName, int outer, int inner) {
        Performance perf = Performance.getDefault();
        PerformanceMeter meter = perf.createPerformanceMeter(perf.getDefaultScenarioId(testCase));
        if (this.regressionReason != null) {
            perf.setComment(meter, 1, this.regressionReason);
        }
        try {
            try {
                int i = 0;
                while (i < outer) {
                    this.setUp();
                    meter.start();
                    int j = 0;
                    while (j < inner) {
                        this.test();
                        ++j;
                    }
                    meter.stop();
                    this.tearDown();
                    ++i;
                }
                if (localName != null) {
                    Performance.getDefault().tagAsSummary(meter, localName, Dimension.ELAPSED_PROCESS);
                }
                if (this.fingerprintName != null) {
                    perf.tagAsSummary(meter, this.fingerprintName, Dimension.ELAPSED_PROCESS);
                }
                meter.commit();
                perf.assertPerformance(meter);
            }
            catch (CoreException e) {
                CoreTest.fail("Failed performance test", e);
                meter.dispose();
            }
        }
        finally {
            meter.dispose();
        }
    }

    protected void setUp() throws CoreException {
    }

    protected void tearDown() throws CoreException {
    }

    public void setFingerprintName(String fingerprintName) {
        this.fingerprintName = fingerprintName;
    }
}

