/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.properties;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.bpel.common.ui.details.viewers.CComboViewer;
import org.eclipse.bpel.common.ui.details.viewers.ComboViewerCellEditor;
import org.eclipse.bpel.common.ui.flatui.FlatFormAttachment;
import org.eclipse.bpel.common.ui.flatui.FlatFormData;
import org.eclipse.bpel.model.BPELFactory;
import org.eclipse.bpel.model.BPELPackage;
import org.eclipse.bpel.model.Correlation;
import org.eclipse.bpel.model.CorrelationPattern;
import org.eclipse.bpel.model.CorrelationSet;
import org.eclipse.bpel.model.Correlations;
import org.eclipse.bpel.model.Invoke;
import org.eclipse.bpel.model.OnEvent;
import org.eclipse.bpel.model.OnMessage;
import org.eclipse.bpel.model.PartnerActivity;
import org.eclipse.bpel.ui.Messages;
import org.eclipse.bpel.ui.commands.AddCorrelationCommand;
import org.eclipse.bpel.ui.commands.RemoveCorrelationCommand;
import org.eclipse.bpel.ui.commands.SetCommand;
import org.eclipse.bpel.ui.commands.SetCorrelationInitiateCommand;
import org.eclipse.bpel.ui.commands.SetCorrelationSetRefCommand;
import org.eclipse.bpel.ui.details.providers.AbstractContentProvider;
import org.eclipse.bpel.ui.details.providers.AddNullFilter;
import org.eclipse.bpel.ui.details.providers.ColumnTableProvider;
import org.eclipse.bpel.ui.details.providers.CorrelationContentProvider;
import org.eclipse.bpel.ui.details.providers.ModelLabelProvider;
import org.eclipse.bpel.ui.details.providers.ModelViewerSorter;
import org.eclipse.bpel.ui.properties.BPELPropertySection;
import org.eclipse.bpel.ui.util.BPELUtil;
import org.eclipse.bpel.ui.util.ModelHelper;
import org.eclipse.bpel.ui.util.MultiObjectAdapter;
import org.eclipse.bpel.ui.util.TableCursor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public class CorrelationSection
extends BPELPropertySection {
    public static final String YES = "yes";
    public static final String NO = "no";
    public static final String JOIN = "join";
    protected Table correlationTable;
    protected TableViewer correlationViewer;
    protected ColumnTableProvider tableProvider;
    protected TableCursor tableCursor = null;
    protected Button addButton;
    protected Button removeButton;
    protected boolean allowOutgoing;
    protected boolean allowIncoming;

    public boolean shouldUseExtraSpace() {
        return true;
    }

    protected boolean isCorrelationListAffected(Notification n) {
        if (n.getNotifier() instanceof Correlations) {
            return true;
        }
        if (n.getNotifier() instanceof PartnerActivity) {
            return n.getFeatureID(PartnerActivity.class) == 9;
        }
        if (n.getNotifier() instanceof OnMessage) {
            return n.getFeatureID(OnMessage.class) == 8;
        }
        if (n.getNotifier() instanceof OnEvent) {
            return n.getFeatureID(OnEvent.class) == 7;
        }
        return false;
    }

    @Override
    protected MultiObjectAdapter[] createAdapters() {
        return new MultiObjectAdapter[]{new MultiObjectAdapter(){

            @Override
            public void notify(Notification n) {
                if (CorrelationSection.this.isCorrelationListAffected(n)) {
                    CorrelationSection.this.updateCorrelationWidgets(null);
                    CorrelationSection.this.refreshAdapters();
                }
            }
        }, new MultiObjectAdapter(){

            @Override
            public void notify(Notification n) {
                Correlations c;
                if (n.getNotifier() instanceof Correlation) {
                    CorrelationSection.this.updateCorrelationWidgets((Correlation)n.getNotifier());
                    CorrelationSection.this.refreshAdapters();
                } else if (n.getNotifier() instanceof CorrelationSet && (c = ModelHelper.getCorrelations(CorrelationSection.this.getInput())) != null) {
                    for (Correlation corr : c.getChildren()) {
                        CorrelationSection.this.fAdapters[1].addToObject((Notifier)corr);
                        if (n.getNotifier() != corr.getSet()) continue;
                        CorrelationSection.this.updateCorrelationWidgets(corr);
                        CorrelationSection.this.refreshAdapters();
                        break;
                    }
                }
            }
        }};
    }

    @Override
    protected void addAllAdapters() {
        super.addAllAdapters();
        Correlations c = ModelHelper.getCorrelations(this.getInput());
        if (c != null) {
            this.fAdapters[0].addToObject((Notifier)c);
            for (Correlation corr : c.getChildren()) {
                this.fAdapters[1].addToObject((Notifier)corr);
                if (corr.getSet() == null) continue;
                this.fAdapters[1].addToObject((Notifier)corr.getSet());
            }
        }
    }

    protected Correlation newDefaultCorrelation() {
        Correlation correlation = BPELFactory.eINSTANCE.createCorrelation();
        correlation.setInitiate(NO);
        if (this.getInput() instanceof Invoke) {
            correlation.setPattern(CorrelationPattern.RESPONSE_LITERAL);
        }
        CorrelationSet firstUnusedSet = null;
        Correlations c = ModelHelper.getCorrelations(this.getInput());
        List corrList = c == null ? Collections.EMPTY_LIST : c.getChildren();
        HashSet<CorrelationSet> usedSets = new HashSet<CorrelationSet>(corrList.size());
        Iterator it = corrList.iterator();
        while (it.hasNext()) {
            usedSets.add(((Correlation)it.next()).getSet());
        }
        for (CorrelationSet set : this.getProcess().getCorrelationSets().getChildren()) {
            if (usedSets.contains(set)) continue;
            firstUnusedSet = set;
            break;
        }
        correlation.setSet(firstUnusedSet);
        return correlation;
    }

    protected void createCorrelationSetWidgets(Composite composite) {
        this.addButton = this.fWidgetFactory.createButton(composite, Messages.CorrelationDetails_Add_18, 8);
        this.removeButton = this.fWidgetFactory.createButton(composite, Messages.CorrelationDetails_Remove_19, 8);
        Label correlationSetLabel = this.fWidgetFactory.createLabel(composite, Messages.CorrelationDetails_Correlation_Sets__20);
        this.correlationTable = this.fWidgetFactory.createTable(composite, 66048);
        FlatFormData data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.top = new FlatFormAttachment(0, 0);
        correlationSetLabel.setLayoutData((Object)data);
        data = new FlatFormData();
        data.width = BPELUtil.calculateButtonWidth((Widget)this.addButton, 60);
        data.right = new FlatFormAttachment((Control)this.removeButton, -5);
        data.top = new FlatFormAttachment(0, 0);
        this.addButton.setLayoutData((Object)data);
        data = new FlatFormData();
        data.width = BPELUtil.calculateButtonWidth((Widget)this.removeButton, 60);
        data.right = new FlatFormAttachment(100, 0);
        data.top = new FlatFormAttachment(0, 0);
        this.removeButton.setLayoutData((Object)data);
        this.removeButton.setEnabled(false);
        this.addButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Correlation correlation = CorrelationSection.this.newDefaultCorrelation();
                AddCorrelationCommand cmd = new AddCorrelationCommand((EObject)CorrelationSection.this.getInput(), correlation);
                CorrelationSection.this.getCommandFramework().execute(CorrelationSection.this.wrapInShowContextCommand((Command)cmd));
                CorrelationSection.this.correlationViewer.setSelection((ISelection)new StructuredSelection((Object)correlation));
                CorrelationSection.this.removeButton.setEnabled(true);
                if (CorrelationSection.this.tableCursor != null) {
                    CorrelationSection.this.tableCursor.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Listener removeListener = new Listener(){

            public void handleEvent(Event e) {
                int items;
                if (e.type == 2 && e.character != '\u007f') {
                    return;
                }
                IStructuredSelection sel = (IStructuredSelection)CorrelationSection.this.correlationViewer.getSelection();
                Correlation correlation = (Correlation)sel.getFirstElement();
                int selectionIndex = CorrelationSection.this.correlationTable.getSelectionIndex();
                if (correlation != null) {
                    RemoveCorrelationCommand cmd = new RemoveCorrelationCommand((EObject)CorrelationSection.this.getInput(), correlation);
                    CorrelationSection.this.getCommandFramework().execute(CorrelationSection.this.wrapInShowContextCommand((Command)cmd));
                }
                if ((items = CorrelationSection.this.correlationTable.getItemCount()) > 0) {
                    selectionIndex = selectionIndex < items ? selectionIndex : 0;
                    CorrelationSection.this.correlationTable.setSelection(selectionIndex);
                }
                if (CorrelationSection.this.tableCursor != null) {
                    CorrelationSection.this.tableCursor.refresh();
                }
                CorrelationSection.this.updateButtonEnablement();
            }
        };
        this.correlationTable.addListener(2, removeListener);
        this.removeButton.addListener(13, removeListener);
        this.removeButton.addListener(14, removeListener);
        data = new FlatFormData();
        data.left = new FlatFormAttachment(0, 0);
        data.right = new FlatFormAttachment(100, 0);
        data.top = new FlatFormAttachment((Control)this.addButton, 4);
        data.bottom = new FlatFormAttachment(100, 0);
        this.correlationTable.setLayoutData((Object)data);
        this.correlationTable.setLinesVisible(true);
        this.correlationTable.setHeaderVisible(true);
        this.tableProvider = new ColumnTableProvider();
        this.tableProvider.add(new DirectionColumn());
        this.tableProvider.add(new InitiationColumn());
        this.tableProvider.add(new NameColumn());
        this.correlationTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                CorrelationSection.this.removeButton.setEnabled(!CorrelationSection.this.correlationViewer.getSelection().isEmpty());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.correlationViewer = new TableViewer(this.correlationTable);
        this.tableProvider.createTableLayout(this.correlationTable);
        this.correlationViewer.setLabelProvider((IBaseLabelProvider)this.tableProvider);
        this.correlationViewer.setCellModifier((ICellModifier)this.tableProvider);
        this.correlationViewer.setContentProvider((IContentProvider)new CorrelationContentProvider());
        this.correlationViewer.setColumnProperties(this.tableProvider.getColumnProperties());
        this.correlationViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CorrelationSection.this.updateButtonEnablement();
            }
        });
        this.tableCursor = BPELUtil.createTableCursor(this.correlationTable, this.correlationViewer);
    }

    @Override
    protected void createClient(Composite parent) {
        Composite composite = this.createFlatFormComposite(parent);
        this.createCorrelationSetWidgets(composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.bpel.ui.property_correlation");
    }

    protected void updateCorrelationWidgets(Correlation corr) {
        Object input = this.getInput();
        if (input == null) {
            throw new IllegalStateException();
        }
        this.allowOutgoing = ModelHelper.isMessageActivity(input, 0);
        this.allowIncoming = ModelHelper.isMessageActivity(input, 1);
        this.correlationViewer.setInput(this.getInput());
        if (corr != null) {
            this.correlationViewer.refresh((Object)corr, true);
        } else {
            this.correlationViewer.refresh();
        }
        if (this.tableCursor != null) {
            this.tableCursor.refresh();
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        this.updateCorrelationWidgets(null);
    }

    @Override
    public Object getUserContext() {
        return ((StructuredSelection)this.correlationViewer.getSelection()).getFirstElement();
    }

    @Override
    public void restoreUserContext(Object userContext) {
        this.correlationTable.setFocus();
        if (userContext != null) {
            this.correlationViewer.setSelection((ISelection)new StructuredSelection(userContext));
        }
    }

    @Override
    protected void basicSetInput(EObject newInput) {
        super.basicSetInput(newInput);
        this.correlationViewer.setCellEditors(this.tableProvider.createCellEditors((Composite)this.correlationTable));
    }

    protected void updateButtonEnablement() {
        boolean hasSelection = !this.correlationViewer.getSelection().isEmpty();
        this.removeButton.setEnabled(hasSelection);
    }

    public class DirectionColumn
    extends ColumnTableProvider.Column
    implements ILabelProvider,
    ICellModifier {
        protected final String[] oneWayStrings = new String[]{Messages.CorrelationDetails_Send_5, Messages.CorrelationDetails_Receive_4};
        protected final String[] twoWayStrings = new String[]{Messages.CorrelationDetails_Send_5, Messages.CorrelationDetails_Receive_6, Messages.CorrelationDetails_Both_7};

        @Override
        public String getHeaderText() {
            return Messages.CorrelationDetails_Direction_1;
        }

        @Override
        public String getProperty() {
            return "direction";
        }

        @Override
        public int getInitialWeight() {
            return 15;
        }

        @Override
        public CellEditor createCellEditor(Composite parent) {
            return new ComboBoxCellEditor(parent, this.twoWayStrings);
        }

        protected int patternIndex(CorrelationPattern pattern) {
            if (pattern == CorrelationPattern.RESPONSE_LITERAL) {
                return 0;
            }
            if (pattern == CorrelationPattern.REQUEST_LITERAL) {
                return 1;
            }
            if (pattern == CorrelationPattern.REQUESTRESPONSE_LITERAL) {
                return 2;
            }
            return CorrelationSection.this.allowOutgoing ? 0 : 1;
        }

        protected CorrelationPattern indexPattern(int index) {
            switch (index) {
                case 0: {
                    return CorrelationPattern.RESPONSE_LITERAL;
                }
                case 1: {
                    return CorrelationPattern.REQUEST_LITERAL;
                }
                case 2: {
                    return CorrelationPattern.REQUESTRESPONSE_LITERAL;
                }
            }
            throw new IllegalArgumentException();
        }

        @Override
        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (CorrelationSection.this.allowOutgoing && CorrelationSection.this.allowIncoming) {
                return this.twoWayStrings[this.patternIndex(((Correlation)element).getPattern())];
            }
            return this.oneWayStrings[CorrelationSection.this.allowOutgoing ? 0 : 1];
        }

        public boolean canModify(Object element, String property) {
            return CorrelationSection.this.allowOutgoing && CorrelationSection.this.allowIncoming;
        }

        public Object getValue(Object element, String property) {
            return this.patternIndex(((Correlation)element).getPattern());
        }

        public void modify(Object element, String property, Object value) {
            int index = (Integer)value;
            CorrelationPattern pattern = this.indexPattern(index);
            SetCommand cmd = new SetCommand((EObject)element, pattern, (EStructuralFeature)BPELPackage.eINSTANCE.getCorrelation_Pattern());
            CorrelationSection.this.getCommandFramework().execute(CorrelationSection.this.wrapInShowContextCommand((Command)cmd));
        }
    }

    public class InitiationColumn
    extends ColumnTableProvider.Column
    implements ILabelProvider,
    ICellModifier {
        protected final String[] strings = new String[]{Messages.CorrelationDetails_No_10, Messages.CorrelationDetails_Yes_11, Messages.CorrelationDetails_Join_11};

        @Override
        public String getHeaderText() {
            return Messages.CorrelationDetails_Initiation_8;
        }

        @Override
        public String getProperty() {
            return "initiation";
        }

        @Override
        public int getInitialWeight() {
            return 10;
        }

        @Override
        public CellEditor createCellEditor(Composite parent) {
            ComboBoxCellEditor result = new ComboBoxCellEditor();
            result.setStyle(8);
            result.create(parent);
            result.setItems(this.strings);
            return result;
        }

        protected int initiationIndex(String initiation) {
            if (CorrelationSection.YES.equals(initiation)) {
                return 1;
            }
            if (CorrelationSection.JOIN.equals(initiation)) {
                return 2;
            }
            return 0;
        }

        public String getText(Object element) {
            return this.strings[this.initiationIndex(((Correlation)element).getInitiate())];
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            return this.initiationIndex(((Correlation)element).getInitiate());
        }

        public void modify(Object element, String property, Object value) {
            int index = (Integer)value;
            String initiation = CorrelationSection.NO;
            switch (index) {
                case 0: {
                    initiation = CorrelationSection.NO;
                    break;
                }
                case 1: {
                    initiation = CorrelationSection.YES;
                    break;
                }
                case 2: {
                    initiation = CorrelationSection.JOIN;
                }
            }
            SetCorrelationInitiateCommand cmd = new SetCorrelationInitiateCommand((Correlation)element, initiation);
            CorrelationSection.this.getCommandFramework().execute(CorrelationSection.this.wrapInShowContextCommand((Command)cmd));
        }
    }

    public class NameColumn
    extends ColumnTableProvider.Column
    implements ILabelProvider,
    ICellModifier {
        ComboViewerCellEditor cellEditor;
        ModelLabelProvider labelProvider;

        @Override
        public String getHeaderText() {
            return Messages.CorrelationDetails_Correlation_Set_12;
        }

        @Override
        public String getProperty() {
            return "setName";
        }

        @Override
        public int getInitialWeight() {
            return 30;
        }

        @Override
        public CellEditor createCellEditor(Composite parent) {
            this.cellEditor = new ComboViewerCellEditor();
            this.cellEditor.setStyle(8);
            this.cellEditor.create(parent);
            this.labelProvider = new ModelLabelProvider();
            CComboViewer viewer = this.cellEditor.getViewer();
            viewer.addFilter((ViewerFilter)AddNullFilter.getInstance());
            viewer.setContentProvider((IContentProvider)new AbstractContentProvider(){

                @Override
                public Object[] getElements(Object input) {
                    if (input instanceof EObject) {
                        return BPELUtil.getVisibleCorrelationSets((EObject)input);
                    }
                    return EMPTY_ARRAY;
                }
            });
            viewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
            viewer.setSorter((ViewerSorter)ModelViewerSorter.getInstance());
            viewer.setInput((Object)ModelHelper.getContainingScope(CorrelationSection.this.getInput()));
            return this.cellEditor;
        }

        public String getText(Object element) {
            return this.labelProvider.getText(((Correlation)element).getSet());
        }

        public boolean canModify(Object element, String property) {
            return true;
        }

        public Object getValue(Object element, String property) {
            return ((Correlation)element).getSet();
        }

        public void modify(Object element, String property, Object value) {
            SetCorrelationSetRefCommand cmd = new SetCorrelationSetRefCommand((Correlation)element, (CorrelationSet)value);
            CorrelationSection.this.getCommandFramework().execute(CorrelationSection.this.wrapInShowContextCommand((Command)cmd));
        }
    }
}

