/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.math.BigDecimal;
import java.util.Comparator;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.NumberAssert;
import org.assertj.core.data.Offset;
import org.assertj.core.data.Percentage;
import org.assertj.core.internal.BigDecimals;
import org.assertj.core.internal.ComparatorBasedComparisonStrategy;
import org.assertj.core.util.CheckReturnValue;
import org.assertj.core.util.VisibleForTesting;

public abstract class AbstractBigDecimalAssert<SELF extends AbstractBigDecimalAssert<SELF>>
extends AbstractComparableAssert<SELF, BigDecimal>
implements NumberAssert<SELF, BigDecimal> {
    @VisibleForTesting
    BigDecimals bigDecimals = BigDecimals.instance();

    protected AbstractBigDecimalAssert(BigDecimal actual, Class<?> selfType) {
        super(actual, selfType);
    }

    @Override
    public SELF isZero() {
        this.bigDecimals.assertIsZero(this.info, (BigDecimal)this.actual);
        return (SELF)((AbstractBigDecimalAssert)this.myself);
    }

    @Override
    public SELF isNotZero() {
        this.bigDecimals.assertIsNotZero(this.info, (BigDecimal)this.actual);
        return (SELF)((AbstractBigDecimalAssert)this.myself);
    }

    @Override
    public SELF isOne() {
        this.bigDecimals.assertIsOne(this.info, (BigDecimal)this.actual);
        return (SELF)((AbstractBigDecimalAssert)this.myself);
    }

    @Override
    public SELF isPositive() {
        this.bigDecimals.assertIsPositive(this.info, (BigDecimal)this.actual);
        return (SELF)((AbstractBigDecimalAssert)this.myself);
    }

    @Override
    public SELF isNegative() {
        this.bigDecimals.assertIsNegative(this.info, (BigDecimal)this.actual);
        return (SELF)((AbstractBigDecimalAssert)this.myself);
    }

    @Override
    public SELF isNotPositive() {
        this.bigDecimals.assertIsNotPositive(this.info, (BigDecimal)this.actual);
        return (SELF)((AbstractBigDecimalAssert)this.myself);
    }

    @Override
    public SELF isNotNegative() {
        this.bigDecimals.assertIsNotNegative(this.info, (BigDecimal)this.actual);
        return (SELF)((AbstractBigDecimalAssert)this.myself);
    }

    @Override
    public SELF isBetween(BigDecimal start, BigDecimal end) {
        this.bigDecimals.assertIsBetween(this.info, (BigDecimal)this.actual, start, end);
        return (SELF)((AbstractBigDecimalAssert)this.myself);
    }

    @Override
    public SELF isStrictlyBetween(BigDecimal start, BigDecimal end) {
        this.bigDecimals.assertIsStrictlyBetween(this.info, (BigDecimal)this.actual, start, end);
        return (SELF)((AbstractBigDecimalAssert)this.myself);
    }

    public SELF isEqualTo(String expected) {
        return (SELF)((AbstractBigDecimalAssert)this.isEqualTo(new BigDecimal(expected)));
    }

    @Override
    public SELF isEqualByComparingTo(String expected) {
        return (SELF)((AbstractBigDecimalAssert)this.isEqualByComparingTo(new BigDecimal(expected)));
    }

    @Override
    public SELF isNotEqualByComparingTo(String notExpected) {
        return (SELF)((AbstractBigDecimalAssert)this.isNotEqualByComparingTo(new BigDecimal(notExpected)));
    }

    @Override
    @CheckReturnValue
    public SELF usingComparator(Comparator<? super BigDecimal> customComparator) {
        return (SELF)this.usingComparator((Comparator)customComparator, (String)null);
    }

    @Override
    @CheckReturnValue
    public SELF usingComparator(Comparator<? super BigDecimal> customComparator, String customComparatorDescription) {
        this.bigDecimals = new BigDecimals(new ComparatorBasedComparisonStrategy(customComparator, customComparatorDescription));
        return (SELF)((AbstractBigDecimalAssert)super.usingComparator(customComparator, customComparatorDescription));
    }

    @Override
    @CheckReturnValue
    public SELF usingDefaultComparator() {
        this.bigDecimals = BigDecimals.instance();
        return (SELF)((AbstractBigDecimalAssert)super.usingDefaultComparator());
    }

    @Override
    public SELF isCloseTo(BigDecimal expected, Offset<BigDecimal> offset) {
        this.bigDecimals.assertIsCloseTo(this.info, (BigDecimal)this.actual, expected, offset);
        return (SELF)((AbstractBigDecimalAssert)this.myself);
    }

    @Override
    public SELF isNotCloseTo(BigDecimal expected, Offset<BigDecimal> offset) {
        this.bigDecimals.assertIsNotCloseTo(this.info, (BigDecimal)this.actual, expected, offset);
        return (SELF)((AbstractBigDecimalAssert)this.myself);
    }

    @Override
    public SELF isCloseTo(BigDecimal expected, Percentage percentage) {
        this.bigDecimals.assertIsCloseToPercentage(this.info, (BigDecimal)this.actual, expected, percentage);
        return (SELF)((AbstractBigDecimalAssert)this.myself);
    }

    @Override
    public SELF isNotCloseTo(BigDecimal expected, Percentage percentage) {
        this.bigDecimals.assertIsNotCloseToPercentage(this.info, (BigDecimal)this.actual, expected, percentage);
        return (SELF)((AbstractBigDecimalAssert)this.myself);
    }

    @Override
    public SELF isLessThanOrEqualTo(BigDecimal other) {
        return (SELF)((AbstractBigDecimalAssert)super.isLessThanOrEqualTo(other));
    }

    @Override
    public SELF isGreaterThanOrEqualTo(BigDecimal other) {
        return (SELF)((AbstractBigDecimalAssert)super.isGreaterThanOrEqualTo(other));
    }
}

