/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsi.internal.core.profile.validator.impl.uddi;

import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.Definition;
import org.eclipse.wst.wsi.internal.core.WSIException;
import org.eclipse.wst.wsi.internal.core.profile.TestAssertion;
import org.eclipse.wst.wsi.internal.core.profile.validator.EntryContext;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.AssertionProcess;
import org.eclipse.wst.wsi.internal.core.profile.validator.impl.uddi.UDDIValidatorImpl;
import org.eclipse.wst.wsi.internal.core.report.AssertionResult;
import org.eclipse.wst.wsi.internal.core.util.UDDIUtils;
import org.eclipse.wst.wsi.internal.core.wsdl.WSDLDocument;
import org.uddi4j.datatype.OverviewDoc;
import org.uddi4j.datatype.tmodel.TModel;

public class BP3001
extends AssertionProcess {
    private final UDDIValidatorImpl validator;

    public BP3001(UDDIValidatorImpl impl) {
        super(impl);
        this.validator = impl;
    }

    private void setFaultMessage(String tModelKey) {
        this.result = "failed";
        this.failureDetailMessage = "The tModel key is: [" + tModelKey + "].";
    }

    @Override
    public AssertionResult validate(TestAssertion testAssertion, EntryContext entryContext) throws WSIException {
        this.result = "passed";
        Binding binding = null;
        TModel tModel = (TModel)entryContext.getEntry().getEntryDetail();
        if (tModel == null) {
            this.result = "failed";
            this.failureDetailMessage = "Could not locate a tModel.";
            return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetailMessage);
        }
        String key = tModel.getTModelKey();
        OverviewDoc doc = tModel.getOverviewDoc();
        if (doc != null) {
            String urlText = doc.getOverviewURLString();
            try {
                WSDLDocument wsdlDocument = new WSDLDocument(urlText);
                Definition definition = wsdlDocument.getDefinitions();
                Map namespaces = definition.getNamespaces();
                if (!namespaces.containsValue("http://schemas.xmlsoap.org/wsdl/")) {
                    urlText = null;
                }
                if ((binding = UDDIUtils.getBinding(urlText, wsdlDocument)) == null || definition.getBinding(binding.getQName()) == null) {
                    urlText = null;
                }
            }
            catch (Exception exception) {
                urlText = null;
            }
            if (urlText != null) {
                String fragmentID = null;
                int index = urlText.indexOf("#");
                if (index > -1) {
                    fragmentID = urlText.substring(index + 1);
                }
                if (fragmentID != null && fragmentID.length() != 0 && (fragmentID.toUpperCase().indexOf("xpointer(".toUpperCase()) == -1 || fragmentID.lastIndexOf(")") != fragmentID.length() - 1)) {
                    this.setFaultMessage(key);
                }
            } else {
                this.setFaultMessage(key);
            }
        } else {
            this.setFaultMessage(key);
        }
        return this.validator.createAssertionResult(testAssertion, this.result, this.failureDetailMessage);
    }
}

