/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.test.internal.performance;

import java.util.Map;
import org.eclipse.test.internal.performance.InternalDimensions;
import org.eclipse.test.internal.performance.PerformanceMonitor;
import org.eclipse.test.internal.performance.PerformanceTestPlugin;

class PerformanceMonitorWindows
extends PerformanceMonitor {
    private boolean fgNativeGetPerformanceInfoNotAvailable;

    PerformanceMonitorWindows() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void collectOperatingSystemCounters(Map scalars) {
        PerformanceMonitorWindows performanceMonitorWindows = this;
        synchronized (performanceMonitorWindows) {
            long[] counters;
            if (org.eclipse.perfmsr.core.PerformanceMonitor.isLoaded() && org.eclipse.perfmsr.core.PerformanceMonitor.nativeGetPerformanceCounters(counters = new long[14])) {
                this.addScalar(scalars, InternalDimensions.WORKING_SET, counters[0]);
                this.addScalar(scalars, InternalDimensions.WORKING_SET_PEAK, counters[1]);
                this.addScalar(scalars, InternalDimensions.ELAPSED_PROCESS, counters[2]);
                this.addScalar(scalars, InternalDimensions.KERNEL_TIME, counters[4]);
                this.addScalar(scalars, InternalDimensions.CPU_TIME, counters[3] + counters[4]);
                this.addScalar(scalars, InternalDimensions.PAGE_FAULTS, counters[5]);
                if (counters[6] != -1L) {
                    this.addScalar(scalars, InternalDimensions.COMITTED, counters[6]);
                }
                this.addScalar(scalars, InternalDimensions.GDI_OBJECTS, counters[7]);
            }
            super.collectOperatingSystemCounters(scalars);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void collectGlobalPerformanceInfo(Map scalars) {
        PerformanceMonitorWindows performanceMonitorWindows = this;
        synchronized (performanceMonitorWindows) {
            if (!this.fgNativeGetPerformanceInfoNotAvailable && org.eclipse.perfmsr.core.PerformanceMonitor.isLoaded()) {
                long[] counters = new long[13];
                try {
                    org.eclipse.perfmsr.core.PerformanceMonitor.nativeGetPerformanceInfo(counters);
                    long pageSize = counters[9];
                    this.addScalar(scalars, InternalDimensions.COMMIT_TOTAL, counters[0] * pageSize);
                    this.addScalar(scalars, InternalDimensions.COMMIT_LIMIT, counters[1] * pageSize);
                    this.addScalar(scalars, InternalDimensions.COMMIT_PEAK, counters[2] * pageSize);
                    this.addScalar(scalars, InternalDimensions.PHYSICAL_TOTAL, counters[3] * pageSize);
                    this.addScalar(scalars, InternalDimensions.PHYSICAL_AVAIL, counters[4] * pageSize);
                    this.addScalar(scalars, InternalDimensions.SYSTEM_CACHE, counters[5] * pageSize);
                    this.addScalar(scalars, InternalDimensions.KERNEL_TOTAL, counters[6] * pageSize);
                    this.addScalar(scalars, InternalDimensions.KERNEL_PAGED, counters[7] * pageSize);
                    this.addScalar(scalars, InternalDimensions.KERNEL_NONPAGED, counters[8] * pageSize);
                    this.addScalar(scalars, InternalDimensions.PAGE_SIZE, counters[9]);
                    this.addScalar(scalars, InternalDimensions.HANDLE_COUNT, counters[10]);
                    this.addScalar(scalars, InternalDimensions.PROCESS_COUNT, counters[11]);
                    this.addScalar(scalars, InternalDimensions.THREAD_COUNT, counters[12]);
                }
                catch (Exception exception) {
                    PerformanceTestPlugin.logWarning("native function GetPerformanceInfo() not available on this version of Windows");
                    this.fgNativeGetPerformanceInfoNotAvailable = true;
                }
            }
            super.collectGlobalPerformanceInfo(scalars);
        }
    }
}

