/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.views.internal;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.tcf.te.core.interfaces.IFilterable;
import org.eclipse.tcf.te.ui.utils.TreeViewerUtil;
import org.eclipse.ui.internal.navigator.NavigatorDecoratingLabelProvider;

public class ViewViewerDecoratingLabelProvider
extends NavigatorDecoratingLabelProvider {
    private TreeViewer viewer;
    private TreePath path;

    public ViewViewerDecoratingLabelProvider(TreeViewer viewer, ILabelProvider commonLabelProvider) {
        super(commonLabelProvider);
        this.viewer = viewer;
    }

    public void update(ViewerCell cell) {
        this.path = cell.getViewerRow().getTreePath();
        super.update(cell);
        this.path = null;
    }

    public String getTextNoDecoration(Object element) {
        DelegatingStyledCellLabelProvider.IStyledLabelProvider provider = this.getStyledStringProvider();
        StyledString styledString = provider.getStyledText(element);
        String text = styledString != null ? styledString.toString() : super.getText(element);
        return text;
    }

    public String getText(Object element) {
        StyledString styledString = super.getStyledText(element);
        String text = styledString != null ? styledString.toString() : super.getText(element);
        IFilterable decorator = this.adaptFilterable(element);
        if (text != null && decorator != null && this.path != null && TreeViewerUtil.isFiltering((TreeViewer)this.viewer, (TreePath)this.path)) {
            return TreeViewerUtil.getDecoratedText((String)text, (TreeViewer)this.viewer, (TreePath)this.path);
        }
        return text;
    }

    public Image getImage(Object element) {
        Image image = super.getImage(element);
        IFilterable decorator = this.adaptFilterable(element);
        if (image != null && decorator != null && this.path != null && TreeViewerUtil.isFiltering((TreeViewer)this.viewer, (TreePath)this.path)) {
            return TreeViewerUtil.getDecoratedImage((Image)image, (TreeViewer)this.viewer, (TreePath)this.path);
        }
        return image;
    }

    protected StyledString getStyledText(Object element) {
        StyledString styledString = super.getStyledText(element);
        IFilterable decorator = this.adaptFilterable(element);
        String text = styledString.getString();
        if (text != null && decorator != null && this.path != null && TreeViewerUtil.isFiltering((TreeViewer)this.viewer, (TreePath)this.path)) {
            String decorated = TreeViewerUtil.getDecoratedText((String)text, (TreeViewer)this.viewer, (TreePath)this.path);
            StyledString.Styler style = this.getDecorationStyle(element);
            return StyledCellLabelProvider.styleDecoratedString((String)decorated, (StyledString.Styler)style, (StyledString)styledString);
        }
        return styledString;
    }

    private IFilterable adaptFilterable(Object element) {
        IFilterable decorator = null;
        if (element instanceof IFilterable) {
            decorator = (IFilterable)element;
        }
        if (decorator == null && element instanceof IAdaptable) {
            decorator = (IFilterable)((IAdaptable)element).getAdapter(IFilterable.class);
        }
        if (decorator == null) {
            decorator = (IFilterable)Platform.getAdapterManager().getAdapter(element, IFilterable.class);
        }
        return decorator;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        Image image = super.getColumnImage(element, columnIndex);
        if (columnIndex == 0) {
            IFilterable decorator = this.adaptFilterable(element);
            if (image != null && decorator != null && this.path != null && TreeViewerUtil.isFiltering((TreeViewer)this.viewer, (TreePath)this.path)) {
                return TreeViewerUtil.getDecoratedImage((Image)image, (TreeViewer)this.viewer, (TreePath)this.path);
            }
        }
        return image;
    }

    public String getColumnText(Object element, int columnIndex) {
        String text = super.getColumnText(element, columnIndex);
        if (columnIndex == 0) {
            IFilterable decorator = this.adaptFilterable(element);
            if (text != null && decorator != null && this.path != null && TreeViewerUtil.isFiltering((TreeViewer)this.viewer, (TreePath)this.path)) {
                return TreeViewerUtil.getDecoratedText((String)text, (TreeViewer)this.viewer, (TreePath)this.path);
            }
        }
        return text;
    }
}

