/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.properties.core.internal.expressions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.eef.common.api.utils.Util;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.sirius.business.api.dialect.description.AbstractInterpretedExpressionQuery;
import org.eclipse.sirius.business.api.dialect.description.IInterpretedExpressionQuery;
import org.eclipse.sirius.business.api.dialect.description.IInterpretedExpressionTargetSwitch;
import org.eclipse.sirius.business.api.dialect.description.MultiLanguagesValidator;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.internal.dialect.description.ToolInterpretedExpressionTargetSwitch;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreterContext;
import org.eclipse.sirius.common.tools.api.interpreter.TypeName;
import org.eclipse.sirius.common.tools.api.interpreter.ValidationResult;
import org.eclipse.sirius.common.tools.api.interpreter.VariableType;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.properties.DynamicMappingForDescription;
import org.eclipse.sirius.properties.GroupDescription;
import org.eclipse.sirius.properties.PageDescription;
import org.eclipse.sirius.properties.PropertiesPackage;
import org.eclipse.sirius.properties.ViewExtensionDescription;
import org.eclipse.sirius.properties.core.api.SiriusInputDescriptor;
import org.eclipse.sirius.properties.core.internal.SiriusToolServices;
import org.eclipse.sirius.properties.core.internal.expressions.DomainClassSwitch;
import org.eclipse.sirius.properties.core.internal.expressions.VSMNavigation;
import org.eclipse.sirius.tools.internal.interpreter.SiriusInterpreterContextFactory;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.sirius.viewpoint.description.DescriptionPackage;
import org.eclipse.sirius.viewpoint.description.Extension;
import org.eclipse.sirius.viewpoint.description.Group;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.tool.InitialOperation;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;
import org.eclipse.sirius.viewpoint.description.validation.ValidationPackage;

public final class PropertiesInterpretedExpressionQuery
extends AbstractInterpretedExpressionQuery
implements IInterpretedExpressionQuery {
    private Collection<EPackage> packagesToImport;

    public PropertiesInterpretedExpressionQuery(EObject target, EStructuralFeature expressionAttribute) {
        super(target, expressionAttribute);
    }

    protected void initializeTargetSwitch() {
        this.targetSwitch = new PropertiesExpressionsGlobalTargetSwitch(this.feature);
    }

    public Collection<EPackage> getPackagesToImport() {
        if (this.packagesToImport == null) {
            this.packagesToImport = PropertiesInterpretedExpressionQuery.getEPackagesInScope(this.target);
        }
        return this.packagesToImport;
    }

    public Collection<String> getDependencies() {
        if (this.dependencies == null) {
            ArrayList<String> result = new ArrayList<String>();
            result.addAll(VSMNavigation.getJavaExtensionsInVSM(this.target));
            result.add(SiriusToolServices.class.getName());
            this.dependencies = result;
        }
        return this.dependencies;
    }

    private static Collection<EPackage> getEPackagesInScope(EObject target) {
        Option viewDescriptionOpt;
        LinkedHashSet<EPackage> result = new LinkedHashSet<EPackage>();
        boolean needsGlobalPackages = false;
        for (RepresentationDescription desc : VSMNavigation.getRepresentationDescriptionsInVSM(target)) {
            EList configured = desc.getMetamodel();
            result.addAll((Collection<EPackage>)configured);
            if (!configured.isEmpty()) continue;
            needsGlobalPackages = true;
        }
        if (needsGlobalPackages) {
            result.addAll(PropertiesInterpretedExpressionQuery.getAllRegisteredEPackages(EPackage.Registry.INSTANCE));
        }
        if ((viewDescriptionOpt = new EObjectQuery(target).getFirstAncestorOfType(PropertiesPackage.Literals.VIEW_EXTENSION_DESCRIPTION)).some()) {
            ViewExtensionDescription ved = (ViewExtensionDescription)viewDescriptionOpt.get();
            result.addAll((Collection<EPackage>)ved.getMetamodels());
        }
        result.add((EPackage)EcorePackage.eINSTANCE);
        result.add((EPackage)ViewpointPackage.eINSTANCE);
        result.add((EPackage)DescriptionPackage.eINSTANCE);
        result.add((EPackage)ToolPackage.eINSTANCE);
        result.add((EPackage)ValidationPackage.eINSTANCE);
        result.add((EPackage)PropertiesPackage.eINSTANCE);
        return result;
    }

    private static Collection<EPackage> getAllRegisteredEPackages(EPackage.Registry source) {
        LinkedHashSet<EPackage> result = new LinkedHashSet<EPackage>();
        LinkedHashSet nsURIs = new LinkedHashSet();
        nsURIs.addAll(source.keySet());
        for (String nsURI : nsURIs) {
            try {
                EPackage ePackage = source.getEPackage(nsURI);
                if (ePackage == null) continue;
                result.add(ePackage);
            }
            catch (Throwable throwable) {}
        }
        return result;
    }

    public Map<String, VariableType> getAvailableVariables() {
        VariableType iteratorType;
        String iteratorName;
        if (this.availableVariables == null) {
            this.availableVariables = new LinkedHashMap();
        }
        EObject cur = this.target;
        while (!(cur instanceof Group) && cur != null) {
            EObject parent = cur.eContainer();
            if (parent instanceof DynamicMappingForDescription && !Util.isBlank((String)(iteratorName = ((DynamicMappingForDescription)parent).getIterator()))) {
                iteratorType = this.getResultType(parent, PropertiesPackage.Literals.ABSTRACT_DYNAMIC_MAPPING_FOR_DESCRIPTION__ITERABLE_EXPRESSION);
                this.availableVariables.put(iteratorName, iteratorType);
            }
            cur = parent;
        }
        if (this.isFromOrInheritsPropertiesEPackage(this.target)) {
            DynamicMappingForDescription forDefinition;
            VariableType candidatesExpressionType;
            this.availableVariables.put("input", VariableType.fromJavaClass(SiriusInputDescriptor.class));
            if (this.feature == PropertiesPackage.Literals.ABSTRACT_SELECT_DESCRIPTION__CANDIDATE_DISPLAY_EXPRESSION) {
                candidatesExpressionType = this.getResultType(this.target, PropertiesPackage.Literals.ABSTRACT_SELECT_DESCRIPTION__CANDIDATES_EXPRESSION);
                this.availableVariables.put("candidate", candidatesExpressionType);
            } else if (this.feature == PropertiesPackage.Literals.ABSTRACT_RADIO_DESCRIPTION__CANDIDATE_DISPLAY_EXPRESSION) {
                candidatesExpressionType = this.getResultType(this.target, PropertiesPackage.Literals.ABSTRACT_RADIO_DESCRIPTION__CANDIDATES_EXPRESSION);
                this.availableVariables.put("candidate", candidatesExpressionType);
            } else if (this.feature == PropertiesPackage.Literals.ABSTRACT_LABEL_DESCRIPTION__DISPLAY_EXPRESSION) {
                candidatesExpressionType = this.getResultType(this.target, PropertiesPackage.Literals.ABSTRACT_LABEL_DESCRIPTION__VALUE_EXPRESSION);
                this.availableVariables.put("value", candidatesExpressionType);
            } else if (this.feature == PropertiesPackage.Literals.ABSTRACT_LIST_DESCRIPTION__DISPLAY_EXPRESSION) {
                candidatesExpressionType = this.getResultType(this.target, PropertiesPackage.Literals.ABSTRACT_LIST_DESCRIPTION__VALUE_EXPRESSION);
                this.availableVariables.put("value", candidatesExpressionType);
            } else if (this.feature == PropertiesPackage.Literals.ABSTRACT_HYPERLINK_DESCRIPTION__DISPLAY_EXPRESSION) {
                candidatesExpressionType = this.getResultType(this.target, PropertiesPackage.Literals.ABSTRACT_HYPERLINK_DESCRIPTION__VALUE_EXPRESSION);
                this.availableVariables.put("value", candidatesExpressionType);
            } else if (this.feature == PropertiesPackage.Literals.ABSTRACT_DYNAMIC_MAPPING_IF_DESCRIPTION__PREDICATE_EXPRESSION && this.target.eContainer() instanceof DynamicMappingForDescription && !Util.isBlank((String)(iteratorName = (forDefinition = (DynamicMappingForDescription)this.target.eContainer()).getIterator()))) {
                iteratorType = this.getResultType((EObject)forDefinition, PropertiesPackage.Literals.ABSTRACT_DYNAMIC_MAPPING_FOR_DESCRIPTION__ITERABLE_EXPRESSION);
                this.availableVariables.put(iteratorName, iteratorType);
            }
            return this.availableVariables;
        }
        return super.getAvailableVariables();
    }

    private boolean isFromOrInheritsPropertiesEPackage(EObject object) {
        Stream<EClass> eClasses = Stream.concat(Stream.of(object.eClass()), object.eClass().getEAllSuperTypes().stream());
        return eClasses.map(EClassifier::getEPackage).anyMatch(ePackage -> ePackage == PropertiesPackage.eINSTANCE);
    }

    protected Option<EObject> getToolContext() {
        Option result = super.getToolContext();
        if (!result.some()) {
            result = this.target instanceof PageDescription || this.target instanceof GroupDescription ? Options.newSome((Object)this.target) : new EObjectQuery(this.target).getFirstAncestorOfType(ToolPackage.Literals.INITIAL_OPERATION);
        }
        return result;
    }

    protected void addVariablesFromToolContext(EObject toolContext) {
        super.addVariablesFromToolContext(toolContext);
        this.availableVariables.put("input", VariableType.fromJavaClass(SiriusInputDescriptor.class));
        if (toolContext instanceof InitialOperation) {
            EReference callbackFeature = toolContext.eContainmentFeature();
            VariableType stringType = VariableType.fromJavaClass(String.class);
            VariableType booleanType = VariableType.fromJavaClass(Boolean.class);
            VariableType unkownType = VariableType.fromString((String)TypeName.EOBJECT_TYPENAME.getCompleteName());
            if (callbackFeature == PropertiesPackage.Literals.ABSTRACT_TEXT_DESCRIPTION__INITIAL_OPERATION || callbackFeature == PropertiesPackage.Literals.ABSTRACT_TEXT_AREA_DESCRIPTION__INITIAL_OPERATION) {
                this.availableVariables.put("newValue", stringType);
            } else if (callbackFeature == PropertiesPackage.Literals.ABSTRACT_CHECKBOX_DESCRIPTION__INITIAL_OPERATION) {
                this.availableVariables.put("newValue", booleanType);
            } else if (callbackFeature == PropertiesPackage.Literals.ABSTRACT_HYPERLINK_DESCRIPTION__INITIAL_OPERATION) {
                Option<Collection<String>> domainClass = VSMNavigation.getDomainClassFromContainingGroup(toolContext);
                if (domainClass.some()) {
                    this.availableVariables.put("selection", VariableType.fromStrings((Collection)((Collection)domainClass.get())));
                } else {
                    this.availableVariables.put("selection", unkownType);
                }
            } else if (callbackFeature == PropertiesPackage.Literals.ABSTRACT_RADIO_DESCRIPTION__INITIAL_OPERATION) {
                this.availableVariables.put("newValue", this.getResultType(toolContext.eContainer(), PropertiesPackage.Literals.ABSTRACT_RADIO_DESCRIPTION__CANDIDATES_EXPRESSION));
            } else if (callbackFeature == PropertiesPackage.Literals.WIDGET_ACTION__INITIAL_OPERATION) {
                Option<Collection<String>> domainClass = VSMNavigation.getDomainClassFromContainingGroup(toolContext);
                if (!domainClass.some()) {
                    this.availableVariables.put("selection", VariableType.fromStrings((Collection)((Collection)domainClass.get())));
                } else {
                    this.availableVariables.put("selection", unkownType);
                }
            } else if (callbackFeature == PropertiesPackage.Literals.ABSTRACT_SELECT_DESCRIPTION__INITIAL_OPERATION) {
                this.availableVariables.put("newValue", this.getResultType(toolContext.eContainer(), PropertiesPackage.Literals.ABSTRACT_SELECT_DESCRIPTION__CANDIDATES_EXPRESSION));
            }
        }
    }

    private VariableType getResultType(EObject owner, EAttribute attr) {
        IInterpreterContext context = SiriusInterpreterContextFactory.createInterpreterContext((EObject)owner, (EStructuralFeature)attr);
        ValidationResult res = MultiLanguagesValidator.getInstance().validateExpression(context, (String)owner.eGet((EStructuralFeature)attr));
        return res.getReturnTypes();
    }

    private static class PropertiesExpressionsGlobalTargetSwitch
    implements IInterpretedExpressionTargetSwitch {
        private final DomainClassSwitch propertiesSwitch;
        private final ToolInterpretedExpressionTargetSwitch delegateSwitch;

        PropertiesExpressionsGlobalTargetSwitch(EStructuralFeature feature) {
            this.propertiesSwitch = new DomainClassSwitch(feature);
            this.delegateSwitch = new CustomToolInterpretedExpressionTargetSwitch(feature, this);
        }

        public Option<Collection<String>> doSwitch(EObject target, boolean considerFeature) {
            LinkedHashSet targetTypes = new LinkedHashSet();
            Option expressionTarget = Options.newSome(targetTypes);
            if (target != null) {
                if (expressionTarget.some() && ((Collection)expressionTarget.get()).isEmpty()) {
                    this.propertiesSwitch.setConsiderFeature(considerFeature);
                    expressionTarget = this.propertiesSwitch.doSwitch(target);
                }
                if (expressionTarget.some() && ((Collection)expressionTarget.get()).isEmpty()) {
                    this.delegateSwitch.setConsiderFeature(considerFeature);
                    expressionTarget = this.delegateSwitch.doSwitch(target);
                }
            }
            return expressionTarget;
        }

        public EObject getFirstRelevantContainer(EObject obj) {
            if (obj != null) {
                EObject container = obj.eContainer();
                while (container != null && !this.isRelevant(container)) {
                    container = container.eContainer();
                }
                return container;
            }
            return null;
        }

        private boolean isRelevant(EObject container) {
            return container instanceof PageDescription || container instanceof GroupDescription;
        }

        private static class CustomToolInterpretedExpressionTargetSwitch
        extends ToolInterpretedExpressionTargetSwitch {
            CustomToolInterpretedExpressionTargetSwitch(EStructuralFeature feature, IInterpretedExpressionTargetSwitch defaultSwitch) {
                super(feature, defaultSwitch);
            }

            protected EObject getFirstContextChangingContainer(EObject element) {
                EObject defaultResult = super.getFirstContextChangingContainer(element);
                if (defaultResult instanceof Extension) {
                    return VSMNavigation.findClosestGroupDescription(element);
                }
                return defaultResult;
            }
        }
    }
}

