/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.extension.after.test.impl;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.reddeer.common.properties.RedDeerProperties;
import org.eclipse.reddeer.core.handler.IBeforeShellIsClosed;
import org.eclipse.reddeer.core.handler.ShellHandler;
import org.eclipse.reddeer.junit.TestInfo;
import org.eclipse.reddeer.junit.extensionpoint.IAfterTest;
import org.eclipse.reddeer.junit.screenshot.CaptureScreenshotException;
import org.eclipse.reddeer.junit.screenshot.ScreenshotCapturer;
import org.eclipse.reddeer.workbench.handler.WorkbenchShellHandler;
import org.eclipse.swt.widgets.Shell;
import org.junit.Assert;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;

public class CloseAllShellsExt
implements IAfterTest {
    public static final boolean CLOSE_ALL_SHELLS = RedDeerProperties.CLOSE_ALL_SHELLS.getBooleanValue();
    private String config;
    private TestClass testClass;
    private Object target;
    private FrameworkMethod method;

    public void runAfterTestClass(String config, TestClass testClass) {
        this.config = config;
        this.testClass = testClass;
        this.target = null;
        this.method = null;
        this.run();
    }

    public void runAfterTest(String config, Object target, FrameworkMethod method) {
        this.config = config;
        this.testClass = null;
        this.target = target;
        this.method = method;
        this.run();
    }

    private void run() {
        BeforeShellIsClosedAdapter beforeShellIsClosedAdapter = new BeforeShellIsClosedAdapter();
        WorkbenchShellHandler.getInstance().closeAllNonWorbenchShells((IBeforeShellIsClosed)beforeShellIsClosedAdapter);
        if (beforeShellIsClosedAdapter.getClosedShellsTitles().size() > 0) {
            Assert.fail((String)("The following shells remained open " + beforeShellIsClosedAdapter.getClosedShellsTitles()));
        }
    }

    public boolean hasToRun() {
        return CLOSE_ALL_SHELLS;
    }

    public long getPriority() {
        return -1000000L;
    }

    private class BeforeShellIsClosedAdapter
    implements IBeforeShellIsClosed {
        private List<String> closedShellsTitles = new ArrayList<String>();

        public void runBeforeShellIsClosed(Shell shell) {
            String shellTitle = ShellHandler.getInstance().getText(shell);
            this.closedShellsTitles.add(shellTitle);
            try {
                String fileName;
                if (CloseAllShellsExt.this.testClass != null) {
                    fileName = ScreenshotCapturer.getScreenshotFileName((Class)CloseAllShellsExt.this.testClass.getJavaClass(), null, (String)("CloseAllShellsExt_closing_" + shellTitle));
                } else if (CloseAllShellsExt.this.target instanceof TestInfo) {
                    TestInfo testInfo = (TestInfo)CloseAllShellsExt.this.target;
                    CloseAllShellsExt.this.config = testInfo.getConfig();
                    fileName = ScreenshotCapturer.getScreenshotFileName((Class)testInfo.getTestObjectClass(), (String)testInfo.getMethodName(), (String)("CloseAllShellsExt_closing_" + shellTitle));
                } else {
                    fileName = ScreenshotCapturer.getScreenshotFileName(CloseAllShellsExt.this.target.getClass(), (String)CloseAllShellsExt.this.method.getName(), (String)("CloseAllShellsExt_closing_" + shellTitle));
                }
                ScreenshotCapturer.getInstance().captureScreenshotOnFailure(CloseAllShellsExt.this.config, fileName);
            }
            catch (CaptureScreenshotException e) {
                e.printStackTrace();
            }
        }

        public List<String> getClosedShellsTitles() {
            return this.closedShellsTitles;
        }
    }
}

