/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.internal.util.om;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.net4j.internal.util.bundle.AbstractPlatform;
import org.eclipse.net4j.internal.util.om.InternalOMJob;
import org.eclipse.net4j.internal.util.om.LegacyBundle;
import org.eclipse.net4j.util.concurrent.ConcurrencyUtil;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.io.IOUtil;
import org.eclipse.net4j.util.om.LegacyUtil;
import org.eclipse.net4j.util.om.OMBundle;

public class LegacyPlatform
extends AbstractPlatform {
    public static final String OPTIONS = ".options";
    private final Map<String, String> debugOptions = new ConcurrentHashMap<String, String>(0);
    private final Map<InternalOMJob, IProgressMonitor> jobMonitors = Collections.synchronizedMap(new HashMap());

    public LegacyPlatform() {
        String debugOptionsPath = System.getProperty("debug.options");
        if (debugOptionsPath == null) {
            debugOptionsPath = System.getProperty("osgi.debug");
        }
        if (debugOptionsPath != null) {
            this.loadDebugOptions(debugOptionsPath);
        }
    }

    private void loadDebugOptions(String debugOptionsPath) {
        block9: {
            if (debugOptionsPath.length() == 0) {
                debugOptionsPath = new File(System.getProperty("user.dir"), OPTIONS).toString();
            }
            BufferedInputStream inputStream = null;
            Properties properties = new Properties();
            try {
                try {
                    inputStream = new BufferedInputStream(new FileInputStream(debugOptionsPath));
                    properties.load(inputStream);
                    for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                        try {
                            String key = (String)entry.getKey();
                            String value = (String)entry.getValue();
                            this.debugOptions.put(key, value.trim());
                        }
                        catch (RuntimeException runtimeException) {
                            // empty catch block
                        }
                    }
                }
                catch (IOException iOException) {
                    IOUtil.closeSilent(inputStream);
                    break block9;
                }
            }
            catch (Throwable throwable) {
                IOUtil.closeSilent(inputStream);
                throw throwable;
            }
            IOUtil.closeSilent(inputStream);
        }
    }

    @Override
    public boolean isOSGiRunning() {
        return false;
    }

    @Override
    protected OMBundle createBundle(String bundleID, Class<?> accessor) {
        return new LegacyBundle(this, bundleID, accessor);
    }

    @Override
    protected String getDebugOption(String bundleID, String option) {
        return this.debugOptions.get(String.valueOf(bundleID) + "/" + option);
    }

    @Override
    protected void setDebugOption(String bundleID, String option, String value, boolean ifAbsent) {
        option = String.valueOf(bundleID) + "/" + option;
        if (ifAbsent) {
            this.debugOptions.putIfAbsent(option, value);
        } else {
            this.debugOptions.put(option, value);
        }
    }

    @Override
    public String[] getCommandLineArgs() {
        return LegacyUtil.getCommandLineArgs();
    }

    @Override
    public void scheduleJob(InternalOMJob job) {
        NullProgressMonitor monitor = new NullProgressMonitor();
        this.jobMonitors.put(job, (IProgressMonitor)monitor);
        ExecutorService threadPool = ConcurrencyUtil.getExecutorService(IPluginContainer.INSTANCE);
        threadPool.submit(() -> this.lambda$0(job, (IProgressMonitor)monitor));
    }

    @Override
    public void cancelJob(InternalOMJob job) {
        IProgressMonitor monitor = this.jobMonitors.get(job);
        if (monitor != null) {
            monitor.setCanceled(true);
        }
    }

    @Override
    public void renameJob(InternalOMJob job, String name) {
    }

    public static boolean clearDebugOptions() {
        if (INSTANCE instanceof LegacyPlatform) {
            LegacyPlatform platform = (LegacyPlatform)INSTANCE;
            platform.debugOptions.clear();
            return true;
        }
        return false;
    }

    private /* synthetic */ void lambda$0(InternalOMJob internalOMJob, IProgressMonitor iProgressMonitor) {
        try {
            internalOMJob.run(iProgressMonitor);
        }
        finally {
            this.jobMonitors.remove(internalOMJob);
        }
    }
}

