/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.gerrit.core.operations;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritClient;
import org.eclipse.mylyn.internal.gerrit.core.client.GerritException;
import org.eclipse.mylyn.internal.gerrit.core.operations.AbstractRequest;
import org.eclipse.mylyn.internal.gerrit.core.operations.Messages;
import org.eclipse.osgi.util.NLS;

public class GerritOperation<T>
extends Job {
    private final GerritClient client;
    private final AbstractRequest<T> request;
    private T operationResult;

    public GerritOperation(String name, GerritClient client, AbstractRequest<T> request) {
        super(name);
        this.client = client;
        this.request = request;
    }

    public IStatus run(IProgressMonitor monitor) {
        SubMonitor.convert((IProgressMonitor)monitor);
        try {
            this.execute(monitor);
        }
        catch (OperationCanceledException e) {
            return Status.CANCEL_STATUS;
        }
        catch (GerritException e) {
            return new Status(4, "org.eclipse.mylyn.gerrit.core", NLS.bind((String)Messages.GerritOperation_Operation_Failed, (Object)e.getMessage()), (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    protected void execute(IProgressMonitor monitor) throws GerritException {
        this.operationResult = this.request.execute(this.client, monitor);
    }

    public T getOperationResult() {
        return this.operationResult;
    }
}

