/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecp.view.internal.provider;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecp.view.spi.model.VView;
import org.eclipse.emf.ecp.view.spi.model.VViewModelProperties;
import org.eclipse.emf.ecp.view.spi.provider.IFilteredViewProvider;
import org.eclipse.emf.ecp.view.spi.provider.IViewProvider;

final class FilteredViewProviderAdapter
implements IFilteredViewProvider {
    private static final Function<IViewProvider, IFilteredViewProvider> FACTORY = FilteredViewProviderAdapter::new;
    private static final Map<IViewProvider, IFilteredViewProvider> INSTANCES = new ConcurrentHashMap<IViewProvider, IFilteredViewProvider>();
    private final IViewProvider delegate;

    private FilteredViewProviderAdapter(IViewProvider delegate) {
        this.delegate = delegate;
    }

    @Override
    public double canProvideViewModel(EObject object, VViewModelProperties properties, Collection<String> requiredKeys) {
        return requiredKeys == null || requiredKeys.isEmpty() ? this.delegate.canProvideViewModel(object, properties) : -1.0;
    }

    @Override
    public VView provideViewModel(EObject object, VViewModelProperties properties, Collection<String> requiredKeys) {
        return requiredKeys == null || requiredKeys.isEmpty() ? this.delegate.provideViewModel(object, properties) : null;
    }

    static IFilteredViewProvider adapt(IViewProvider provider) {
        if (provider instanceof IFilteredViewProvider) {
            return (IFilteredViewProvider)provider;
        }
        return INSTANCES.computeIfAbsent(provider, FACTORY);
    }

    static void dispose(IFilteredViewProvider adapter) {
        if (adapter instanceof FilteredViewProviderAdapter) {
            INSTANCES.remove(((FilteredViewProviderAdapter)adapter).delegate);
        }
    }
}

