/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.net4j;

import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.emf.cdo.common.CDOCommonRepository;
import org.eclipse.emf.cdo.common.CDOCommonSession;
import org.eclipse.emf.cdo.common.revision.CDORevisionUtil;
import org.eclipse.emf.cdo.common.util.NotAuthenticatedException;
import org.eclipse.emf.cdo.internal.common.model.CDOPackageRegistryImpl;
import org.eclipse.emf.cdo.internal.net4j.CDONet4jSessionConfigurationImpl;
import org.eclipse.emf.cdo.internal.net4j.protocol.CDOClientProtocol;
import org.eclipse.emf.cdo.net4j.CDONet4jSession;
import org.eclipse.emf.cdo.net4j.CDOSession;
import org.eclipse.emf.cdo.session.CDORepositoryInfo;
import org.eclipse.emf.cdo.spi.common.branch.CDOBranchUtil;
import org.eclipse.emf.cdo.spi.common.branch.InternalCDOBranchManager;
import org.eclipse.emf.cdo.spi.common.commit.CDOCommitInfoUtil;
import org.eclipse.emf.cdo.spi.common.commit.InternalCDOCommitInfoManager;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevisionManager;
import org.eclipse.emf.internal.cdo.session.CDOSessionImpl;
import org.eclipse.emf.internal.cdo.session.DelegatingSessionProtocol;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.emf.spi.cdo.InternalCDOSession;
import org.eclipse.net4j.connector.IConnector;
import org.eclipse.net4j.signal.ISignalProtocol;
import org.eclipse.net4j.signal.RemoteException;
import org.eclipse.net4j.util.container.ContainerUtil;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.io.IStreamWrapper;

public class CDONet4jSessionImpl
extends CDOSessionImpl
implements CDOSession {
    private IStreamWrapper streamWrapper;
    private IConnector connector;
    private String repositoryName;
    private long signalTimeout = 10000L;

    public IManagedContainer getContainer() {
        IManagedContainer container = ContainerUtil.getContainer((Object)this.connector);
        if (container != null) {
            return container;
        }
        return super.getContainer();
    }

    public IStreamWrapper getStreamWrapper() {
        return this.streamWrapper;
    }

    public void setStreamWrapper(IStreamWrapper streamWrapper) {
        this.streamWrapper = streamWrapper;
    }

    public IConnector getConnector() {
        return this.connector;
    }

    public void setConnector(IConnector connector) {
        this.connector = connector;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public long getSignalTimeout() {
        return this.signalTimeout;
    }

    public void setSignalTimeout(long signalTimeout) {
        this.signalTimeout = signalTimeout;
        CDOClientProtocol clientProtocol = this.getClientProtocol();
        if (clientProtocol != null) {
            clientProtocol.setTimeout(this.signalTimeout);
        }
    }

    @Deprecated
    public void changeCredentials() {
        this.changeServerPassword();
        CDOSessionProtocol sessionProtocol = this.getSessionProtocol();
        sessionProtocol.requestChangeCredentials();
    }

    public char[] changeServerPassword() {
        AtomicReference<Object> result = new AtomicReference<Object>();
        CDOSessionProtocol sessionProtocol = this.getSessionProtocol();
        sessionProtocol.requestChangeServerPassword(result);
        return result.getAndSet(null);
    }

    public void resetCredentials(String userID) {
        CDOSessionProtocol sessionProtocol = this.getSessionProtocol();
        sessionProtocol.requestResetCredentials(userID);
    }

    @Override
    public OptionsImpl options() {
        return (OptionsImpl)super.options();
    }

    protected OptionsImpl createOptions() {
        return new OptionsImpl();
    }

    protected InternalCDOBranchManager createBranchManager() {
        return CDOBranchUtil.createBranchManager();
    }

    protected CDOSessionProtocol.OpenSessionResult openSession() {
        CDOSessionProtocol.OpenSessionResult result;
        block4: {
            CDOClientProtocol protocol = this.createProtocol();
            this.setSessionProtocol(protocol);
            this.hookSessionProtocol();
            try {
                String userID = this.getUserID();
                boolean passiveUpdateEnabled = this.options().isPassiveUpdateEnabled();
                CDOCommonSession.Options.PassiveUpdateMode passiveUpdateMode = this.options().getPassiveUpdateMode();
                CDOCommonSession.Options.LockNotificationMode lockNotificationMode = this.options().getLockNotificationMode();
                result = protocol.openSession(this.repositoryName, userID, passiveUpdateEnabled, passiveUpdateMode, lockNotificationMode);
                if (result != null) break block4;
                return null;
            }
            catch (RemoteException ex) {
                if (ex.getCause() instanceof SecurityException) {
                    throw (SecurityException)ex.getCause();
                }
                throw ex;
            }
        }
        this.setSessionID(result.getSessionID());
        this.setUserID(result.getUserID());
        this.setLastUpdateTime(result.getLastUpdateTime());
        this.setOpeningTime(result.getOpeningTime());
        this.setRepositoryInfo(new CDONet4jSessionConfigurationImpl.RepositoryInfo((InternalCDOSession)this, result));
        return result;
    }

    protected void doActivate() throws Exception {
        InternalCDOCommitInfoManager commitInfoManager;
        InternalCDOBranchManager branchManager;
        InternalCDOPackageRegistry packageRegistry = this.getPackageRegistry();
        if (packageRegistry == null) {
            packageRegistry = new CDOPackageRegistryImpl();
            this.setPackageRegistry(packageRegistry);
        }
        packageRegistry.setPackageProcessor((InternalCDOPackageRegistry.PackageProcessor)this);
        packageRegistry.setPackageLoader((InternalCDOPackageRegistry.PackageLoader)this);
        packageRegistry.activate();
        CDOSessionProtocol.OpenSessionResult result = this.openSession();
        if (result == null) {
            throw new NotAuthenticatedException();
        }
        super.doActivate();
        CDORepositoryInfo repository = this.getRepositoryInfo();
        CDOSessionProtocol sessionProtocol = this.getSessionProtocol();
        InternalCDORevisionManager revisionManager = this.getRevisionManager();
        if (revisionManager == null) {
            revisionManager = (InternalCDORevisionManager)CDORevisionUtil.createRevisionManager();
            this.setRevisionManager(revisionManager);
        }
        if (!revisionManager.isActive()) {
            revisionManager.setSupportingAudits(repository.isSupportingAudits());
            revisionManager.setSupportingBranches(repository.isSupportingBranches());
            revisionManager.setRevisionLoader((InternalCDORevisionManager.RevisionLoader)sessionProtocol);
            revisionManager.setRevisionLocker((InternalCDORevisionManager.RevisionLocker)this);
            revisionManager.activate();
        }
        if ((branchManager = this.getBranchManager()) == null) {
            branchManager = this.createBranchManager();
            this.setBranchManager(branchManager);
        }
        if (!branchManager.isActive()) {
            branchManager.setRepository((CDOCommonRepository)repository);
            branchManager.setBranchLoader((InternalCDOBranchManager.BranchLoader)sessionProtocol);
            branchManager.initMainBranch(this.isMainBranchLocal(), repository.getCreationTime());
            branchManager.setTagModCount(result.getTagModCount());
            branchManager.activate();
        }
        if ((commitInfoManager = this.getCommitInfoManager()) == null) {
            commitInfoManager = CDOCommitInfoUtil.createCommitInfoManager((boolean)true);
            this.setCommitInfoManager(commitInfoManager);
        }
        if (!commitInfoManager.isActive()) {
            commitInfoManager.setRepository((CDOCommonRepository)repository);
            commitInfoManager.setCommitInfoLoader((InternalCDOCommitInfoManager.CommitInfoLoader)sessionProtocol);
            commitInfoManager.setLastCommitOfBranch(null, this.getLastUpdateTime());
            commitInfoManager.activate();
        }
        for (InternalCDOPackageUnit packageUnit : result.getPackageUnits()) {
            this.getPackageRegistry().putPackageUnit(packageUnit);
        }
        repository.getTimeStamp(true);
        sessionProtocol.openedSession();
    }

    protected void doDeactivate() throws Exception {
        InternalCDOBranchManager branchManager;
        InternalCDORevisionManager revisionManager;
        CDOSessionProtocol sessionProtocol = this.getSessionProtocol();
        super.doDeactivate();
        InternalCDOCommitInfoManager commitInfoManager = this.getCommitInfoManager();
        if (commitInfoManager.getCommitInfoLoader() == sessionProtocol) {
            commitInfoManager.deactivate();
        }
        if ((revisionManager = this.getRevisionManager()).getRevisionLoader() == sessionProtocol) {
            revisionManager.deactivate();
        }
        if ((branchManager = this.getBranchManager()).getBranchLoader() == sessionProtocol) {
            branchManager.deactivate();
        }
        this.getPackageRegistry().deactivate();
    }

    private CDOClientProtocol createProtocol() {
        CDOClientProtocol protocol = new CDOClientProtocol();
        protocol.setInfraStructure(this);
        if (this.streamWrapper != null) {
            protocol.setStreamWrapper(this.streamWrapper);
        }
        protocol.open(this.connector);
        protocol.setTimeout(this.signalTimeout);
        return protocol;
    }

    private CDOClientProtocol getClientProtocol() {
        CDOSessionProtocol sessionProtocol = this.getSessionProtocol();
        CDOClientProtocol clientProtocol = sessionProtocol instanceof DelegatingSessionProtocol ? (CDOClientProtocol)((DelegatingSessionProtocol)sessionProtocol).getDelegate() : (CDOClientProtocol)sessionProtocol;
        return clientProtocol;
    }

    protected class OptionsImpl
    extends CDOSessionImpl.OptionsImpl
    implements CDOSession.Options {
        private int commitTimeout;
        private int progressInterval;

        public OptionsImpl() {
            super((CDOSessionImpl)CDONet4jSessionImpl.this);
            this.commitTimeout = 10;
            this.progressInterval = 1;
        }

        public CDONet4jSession getContainer() {
            return (CDONet4jSession)super.getContainer();
        }

        @Override
        public ISignalProtocol<CDONet4jSession> getNet4jProtocol() {
            CDOSessionProtocol protocol = CDONet4jSessionImpl.this.getSessionProtocol();
            if (protocol instanceof DelegatingSessionProtocol) {
                protocol = ((DelegatingSessionProtocol)protocol).getDelegate();
            }
            ISignalProtocol signalProtocol = (ISignalProtocol)protocol;
            return signalProtocol;
        }

        @Override
        public ISignalProtocol<CDOSession> getProtocol() {
            ISignalProtocol<CDONet4jSession> net4jProtocol = this.getNet4jProtocol();
            return net4jProtocol;
        }

        @Override
        public int getCommitTimeout() {
            return this.commitTimeout;
        }

        @Override
        public synchronized void setCommitTimeout(int commitTimeout) {
            this.commitTimeout = commitTimeout;
        }

        @Override
        public int getProgressInterval() {
            return this.progressInterval;
        }

        @Override
        public synchronized void setProgressInterval(int progressInterval) {
            this.progressInterval = progressInterval;
        }
    }
}

