/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.features.data;

import org.eclipse.bpmn2.DataState;
import org.eclipse.bpmn2.ItemAwareElement;
import org.eclipse.bpmn2.modeler.core.features.AbstractUpdateBaseElementFeature;
import org.eclipse.bpmn2.modeler.core.utils.FeatureSupport;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.graphiti.features.IFeatureProvider;
import org.eclipse.graphiti.features.IReason;
import org.eclipse.graphiti.features.context.IUpdateContext;
import org.eclipse.graphiti.features.impl.Reason;
import org.eclipse.graphiti.mm.PropertyContainer;
import org.eclipse.graphiti.mm.algorithms.Polyline;
import org.eclipse.graphiti.mm.pictograms.ContainerShape;
import org.eclipse.graphiti.mm.pictograms.PictogramElement;
import org.eclipse.graphiti.mm.pictograms.Shape;
import org.eclipse.graphiti.services.Graphiti;
import org.eclipse.graphiti.services.IPeService;

public class UpdateItemAwareElementFeature<T extends ItemAwareElement>
extends AbstractUpdateBaseElementFeature<ItemAwareElement> {
    public UpdateItemAwareElementFeature(IFeatureProvider fp) {
        super(fp);
    }

    public IReason updateNeeded(IUpdateContext context) {
        String oldDataState;
        boolean oldIsCollection;
        boolean newIsCollection;
        IReason reason = super.updateNeeded(context);
        if (reason.toBoolean()) {
            return reason;
        }
        Graphiti.getPeService();
        ContainerShape container = (ContainerShape)context.getPictogramElement();
        ItemAwareElement element = (ItemAwareElement)this.getBusinessObjectForPictogramElement((PictogramElement)container);
        EStructuralFeature isCollection = element.eClass().getEStructuralFeature("isCollection");
        if (isCollection != null && (newIsCollection = ((Boolean)element.eGet(isCollection)).booleanValue()) != (oldIsCollection = Boolean.parseBoolean(FeatureSupport.getPropertyValue((PropertyContainer)container, (String)"isCollection")))) {
            return Reason.createTrueReason((String)"Cardinality Changed");
        }
        String newDataState = this.getDataStateAsString(element);
        if (!newDataState.equals(oldDataState = FeatureSupport.getPropertyValue((PropertyContainer)container, (String)"datastate"))) {
            return Reason.createTrueReason((String)"Data State Changed");
        }
        return Reason.createFalseReason();
    }

    public boolean update(IUpdateContext context) {
        IPeService peService = Graphiti.getPeService();
        ContainerShape container = (ContainerShape)context.getPictogramElement();
        ItemAwareElement element = (ItemAwareElement)this.getBusinessObjectForPictogramElement((PictogramElement)container);
        EStructuralFeature isCollection = element.eClass().getEStructuralFeature("isCollection");
        if (isCollection != null) {
            boolean newIsCollection = (Boolean)element.eGet(isCollection);
            for (Shape shape : peService.getAllContainedShapes(container)) {
                String prop = FeatureSupport.getPropertyValue((PropertyContainer)shape, (String)"hideable");
                if (prop == null || !new Boolean(prop).booleanValue()) continue;
                Polyline line = (Polyline)shape.getGraphicsAlgorithm();
                line.setLineVisible(Boolean.valueOf(newIsCollection));
            }
            FeatureSupport.setPropertyValue((PropertyContainer)container, (String)"isCollection", (String)Boolean.toString(newIsCollection));
        }
        String newDataState = this.getDataStateAsString(element);
        FeatureSupport.setPropertyValue((PropertyContainer)container, (String)"datastate", (String)newDataState);
        return true;
    }

    private String getDataStateAsString(ItemAwareElement element) {
        String id;
        DataState dataState = element.getDataState();
        if (dataState == null) {
            return "";
        }
        String name = dataState.getName();
        if (name == null || name.isEmpty()) {
            name = "no_name";
        }
        if ((id = dataState.getId()) == null || id.isEmpty()) {
            id = "no_id";
        }
        return String.valueOf(name) + " - " + id;
    }
}

