/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.model.attribute;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum TickStyle implements Enumerator
{
    LEFT_LITERAL(0, "Left", "Left"),
    RIGHT_LITERAL(1, "Right", "Right"),
    ABOVE_LITERAL(2, "Above", "Above"),
    BELOW_LITERAL(3, "Below", "Below"),
    ACROSS_LITERAL(4, "Across", "Across");

    public static final int LEFT = 0;
    public static final int RIGHT = 1;
    public static final int ABOVE = 2;
    public static final int BELOW = 3;
    public static final int ACROSS = 4;
    private static final TickStyle[] VALUES_ARRAY;
    public static final List<TickStyle> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TickStyle[]{LEFT_LITERAL, RIGHT_LITERAL, ABOVE_LITERAL, BELOW_LITERAL, ACROSS_LITERAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TickStyle get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TickStyle result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TickStyle getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TickStyle result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TickStyle get(int value) {
        switch (value) {
            case 0: {
                return LEFT_LITERAL;
            }
            case 1: {
                return RIGHT_LITERAL;
            }
            case 2: {
                return ABOVE_LITERAL;
            }
            case 3: {
                return BELOW_LITERAL;
            }
            case 4: {
                return ACROSS_LITERAL;
            }
        }
        return null;
    }

    private TickStyle(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

