/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util.diff;

import java.util.List;
import org.assertj.core.configuration.ConfigurationProvider;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.diff.Chunk;

public abstract class Delta<T> {
    public static final String DEFAULT_END = "]";
    public static final String DEFAULT_START = "[";
    private Chunk<T> original;
    private Chunk<T> revised;

    public Delta(Chunk<T> original, Chunk<T> revised) {
        Preconditions.checkArgument(original != null, "original must not be null", new Object[0]);
        Preconditions.checkArgument(revised != null, "revised must not be null", new Object[0]);
        this.original = original;
        this.revised = revised;
    }

    public abstract void verify(List<T> var1) throws IllegalStateException;

    public abstract void applyTo(List<T> var1) throws IllegalStateException;

    public abstract TYPE getType();

    public Chunk<T> getOriginal() {
        return this.original;
    }

    public Chunk<T> getRevised() {
        return this.revised;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.original == null ? 0 : this.original.hashCode());
        result = 31 * result + (this.revised == null ? 0 : this.revised.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Delta other = (Delta)obj;
        if (this.original == null ? other.original != null : !this.original.equals(other.original)) {
            return false;
        }
        return !(this.revised == null ? other.revised != null : !this.revised.equals(other.revised));
    }

    public int lineNumber() {
        return this.getOriginal().getPosition() + 1;
    }

    public String toString() {
        return ConfigurationProvider.CONFIGURATION_PROVIDER.representation().toStringOf(this);
    }

    public static enum TYPE {
        CHANGE,
        DELETE,
        INSERT;

    }
}

