/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.equinox.requirements;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.osgi.util.NLS;
import org.eclipse.passage.lic.internal.api.ServiceInvocationResult;
import org.eclipse.passage.lic.internal.api.diagnostic.Trouble;
import org.eclipse.passage.lic.internal.api.diagnostic.TroubleCode;
import org.eclipse.passage.lic.internal.api.requirements.Feature;
import org.eclipse.passage.lic.internal.api.requirements.Requirement;
import org.eclipse.passage.lic.internal.api.restrictions.RestrictionLevel;
import org.eclipse.passage.lic.internal.base.BaseServiceInvocationResult;
import org.eclipse.passage.lic.internal.base.diagnostic.code.ServiceFailedOnMorsel;
import org.eclipse.passage.lic.internal.base.requirements.BaseFeature;
import org.eclipse.passage.lic.internal.base.requirements.BaseRequirement;
import org.eclipse.passage.lic.internal.base.restrictions.DefaultRestrictionLevel;
import org.eclipse.passage.lic.internal.base.version.DefaultVersion;
import org.eclipse.passage.lic.internal.base.version.SafeVersion;
import org.eclipse.passage.lic.internal.equinox.i18n.EquinoxMessages;
import org.eclipse.passage.lic.internal.equinox.requirements.BundleName;
import org.eclipse.passage.lic.internal.equinox.requirements.BundleVendor;
import org.eclipse.passage.lic.internal.equinox.requirements.CapabilityLicFeatureId;
import org.eclipse.passage.lic.internal.equinox.requirements.CapabilityLicFeatureLevel;
import org.eclipse.passage.lic.internal.equinox.requirements.CapabilityLicFeatureName;
import org.eclipse.passage.lic.internal.equinox.requirements.CapabilityLicFeatureProvider;
import org.eclipse.passage.lic.internal.equinox.requirements.CapabilityLicFeatureVersion;
import org.eclipse.passage.lic.internal.equinox.requirements.LicCapabilityNamespace;
import org.osgi.framework.Bundle;

final class RequirementFromAttributes
implements Supplier<ServiceInvocationResult<Collection<Requirement>>> {
    private final Bundle bundle;
    private final Map<String, Object> attributes;

    public RequirementFromAttributes(Bundle bundle, Map<String, Object> attributes) {
        this.bundle = bundle;
        this.attributes = attributes;
    }

    @Override
    public ServiceInvocationResult<Collection<Requirement>> get() {
        Optional feature = new CapabilityLicFeatureId(this.attributes).get();
        if (!feature.isPresent()) {
            return this.fail(NLS.bind((String)EquinoxMessages.RequirementsFromCapability_no_feature_id, (Object)new LicCapabilityNamespace().get(), (Object)new BundleName(this.bundle).get()));
        }
        return this.succeed(this.requirementFromAttributes((String)feature.get()));
    }

    private Requirement requirementFromAttributes(String feature) {
        String version = new CapabilityLicFeatureVersion(this.attributes).get().map(value -> new SafeVersion(value).value()).orElse(new DefaultVersion().value());
        String name = new CapabilityLicFeatureName(this.attributes).get().orElse(feature);
        String provider = new CapabilityLicFeatureProvider(this.attributes).get().orElseGet(new BundleVendor(this.bundle));
        RestrictionLevel level = new CapabilityLicFeatureLevel(this.attributes).get().map(RestrictionLevel.Of::new).orElseGet((Supplier<RestrictionLevel>)new DefaultRestrictionLevel());
        BaseRequirement requirement = new BaseRequirement((Feature)new BaseFeature(feature, version, name, provider), level, (Object)this.bundle.getSymbolicName());
        return requirement;
    }

    private ServiceInvocationResult<Collection<Requirement>> fail(String explanation) {
        return new BaseServiceInvocationResult(new Trouble((TroubleCode)new ServiceFailedOnMorsel(), explanation));
    }

    private ServiceInvocationResult<Collection<Requirement>> succeed(Requirement requirement) {
        return new BaseServiceInvocationResult(Collections.singleton(requirement));
    }
}

