/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.core.data;

import java.io.File;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.DelegatingProgressMonitor;
import org.eclipse.mylyn.commons.core.IDelegatingProgressMonitor;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.tasks.core.AbstractTask;
import org.eclipse.mylyn.internal.tasks.core.ITaskListRunnable;
import org.eclipse.mylyn.internal.tasks.core.TaskActivityManager;
import org.eclipse.mylyn.internal.tasks.core.TaskList;
import org.eclipse.mylyn.internal.tasks.core.TaskTask;
import org.eclipse.mylyn.internal.tasks.core.data.ITaskDataManagerListener;
import org.eclipse.mylyn.internal.tasks.core.data.SynchronizationManger;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataDiff;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataFileManager;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataManagerEvent;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataState;
import org.eclipse.mylyn.internal.tasks.core.data.TaskDataStore;
import org.eclipse.mylyn.tasks.core.AbstractRepositoryConnector;
import org.eclipse.mylyn.tasks.core.IRepositoryManager;
import org.eclipse.mylyn.tasks.core.ITask;
import org.eclipse.mylyn.tasks.core.TaskRepository;
import org.eclipse.mylyn.tasks.core.data.ITaskDataManager;
import org.eclipse.mylyn.tasks.core.data.ITaskDataWorkingCopy;
import org.eclipse.mylyn.tasks.core.data.TaskAttribute;
import org.eclipse.mylyn.tasks.core.data.TaskData;

public class TaskDataManager
implements ITaskDataManager {
    private final IRepositoryManager repositoryManager;
    private final TaskDataStore taskDataStore;
    private final TaskList taskList;
    private final TaskActivityManager taskActivityManager;
    private final List<ITaskDataManagerListener> listeners = new CopyOnWriteArrayList<ITaskDataManagerListener>();
    private final SynchronizationManger synchronizationManager;
    private final TaskDataFileManager fileManager = new TaskDataFileManager();

    public TaskDataManager(TaskDataStore taskDataStore, IRepositoryManager repositoryManager, TaskList taskList, TaskActivityManager taskActivityManager, SynchronizationManger synchronizationManager) {
        this.taskDataStore = taskDataStore;
        this.repositoryManager = repositoryManager;
        this.taskList = taskList;
        this.taskActivityManager = taskActivityManager;
        this.synchronizationManager = synchronizationManager;
    }

    public void addListener(ITaskDataManagerListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ITaskDataManagerListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public ITaskDataWorkingCopy createWorkingCopy(ITask task, TaskData taskData) {
        Assert.isNotNull((Object)task);
        TaskDataState state = new TaskDataState(taskData.getConnectorKind(), taskData.getRepositoryUrl(), taskData.getTaskId());
        state.setRepositoryData(taskData);
        state.setLastReadData(taskData);
        state.init(this, task);
        state.setSaved(false);
        state.revert();
        return state;
    }

    @Override
    public ITaskDataWorkingCopy getWorkingCopy(ITask itask) throws CoreException {
        return this.getWorkingCopy(itask, true);
    }

    public ITaskDataWorkingCopy getWorkingCopy(ITask itask, final boolean markRead) throws CoreException {
        final AbstractTask task = (AbstractTask)itask;
        Assert.isNotNull((Object)task);
        final String kind = task.getConnectorKind();
        final TaskDataState[] result = new TaskDataState[1];
        final boolean[] changed = new boolean[1];
        this.taskList.run(new ITaskListRunnable(){

            @Override
            public void execute(IProgressMonitor monitor) throws CoreException {
                File file = TaskDataManager.this.getMigratedFile(task, kind);
                TaskDataState state = TaskDataManager.this.taskDataStore.getTaskDataState(file);
                if (state == null) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Task data at \"" + file + "\" not found"));
                }
                if (task.isMarkReadPending()) {
                    state.setLastReadData(state.getRepositoryData());
                }
                state.init(TaskDataManager.this, task);
                state.revert();
                if (markRead) {
                    switch (task.getSynchronizationState()) {
                        case INCOMING: 
                        case INCOMING_NEW: {
                            task.setSynchronizationState(ITask.SynchronizationState.SYNCHRONIZED);
                            changed[0] = true;
                            break;
                        }
                        case CONFLICT: {
                            task.setSynchronizationState(ITask.SynchronizationState.OUTGOING);
                            changed[0] = true;
                        }
                    }
                    task.setMarkReadPending(true);
                }
                result[0] = state;
            }
        }, null, true);
        if (changed[0]) {
            this.taskList.notifyElementChanged(task);
        }
        return result[0];
    }

    public void saveWorkingCopy(ITask itask, final TaskDataState state) throws CoreException {
        final AbstractTask task = (AbstractTask)itask;
        Assert.isNotNull((Object)task);
        final String kind = task.getConnectorKind();
        final boolean[] changed = new boolean[1];
        this.taskList.run(new ITaskListRunnable(){

            @Override
            public void execute(IProgressMonitor monitor) throws CoreException {
                File file = TaskDataManager.this.fileManager.getFile(task, kind);
                TaskDataManager.this.taskDataStore.putTaskData(TaskDataManager.this.ensurePathExists(file), state);
                switch (task.getSynchronizationState()) {
                    case SYNCHRONIZED: {
                        task.setSynchronizationState(ITask.SynchronizationState.OUTGOING);
                        changed[0] = true;
                    }
                }
                TaskDataManager.this.taskList.addTask(task);
            }
        });
        if (changed[0]) {
            this.taskList.notifyElementChanged(task);
        }
    }

    public void putUpdatedTaskData(ITask itask, TaskData taskData, boolean user) throws CoreException {
        this.putUpdatedTaskData(itask, taskData, user, null);
    }

    public void putUpdatedTaskData(ITask itask, TaskData taskData, boolean user, Object token) throws CoreException {
        this.putUpdatedTaskData(itask, taskData, user, null, null);
    }

    public void putUpdatedTaskData(ITask itask, final TaskData taskData, final boolean user, Object token, IProgressMonitor monitor) throws CoreException {
        final AbstractTask task = (AbstractTask)itask;
        Assert.isNotNull((Object)task);
        Assert.isNotNull((Object)taskData);
        final AbstractRepositoryConnector connector = this.repositoryManager.getRepositoryConnector(task.getConnectorKind());
        final TaskRepository repository = this.repositoryManager.getRepository(task.getConnectorKind(), task.getRepositoryUrl());
        final boolean taskDataChanged = connector.hasTaskChanged(repository, task, taskData);
        final TaskDataManagerEvent event = new TaskDataManagerEvent(this, itask, taskData, token);
        event.setTaskDataChanged(taskDataChanged);
        IDelegatingProgressMonitor delegatingMonitor = DelegatingProgressMonitor.getMonitorFrom((IProgressMonitor)monitor);
        if (delegatingMonitor != null) {
            event.setData(delegatingMonitor.getData());
        }
        final boolean[] synchronizationStateChanged = new boolean[1];
        if (taskDataChanged || user) {
            this.taskList.run(new ITaskListRunnable(){

                @Override
                public void execute(IProgressMonitor monitor) throws CoreException {
                    TaskDataState state = null;
                    if (!taskData.isPartial()) {
                        File file = TaskDataManager.this.getMigratedFile(task, task.getConnectorKind());
                        state = TaskDataManager.this.taskDataStore.putTaskData(TaskDataManager.this.ensurePathExists(file), taskData, task.isMarkReadPending(), user);
                        task.setMarkReadPending(false);
                        event.setTaskDataUpdated(true);
                    }
                    boolean taskChanged = TaskDataManager.this.updateTaskFromTaskData(taskData, task, connector, repository);
                    event.setTaskChanged(taskChanged);
                    if (taskDataChanged) {
                        String suppressIncoming = null;
                        if (state == null) {
                            File file = TaskDataManager.this.getMigratedFile(task, task.getConnectorKind());
                            state = TaskDataManager.this.taskDataStore.getTaskDataState(TaskDataManager.this.ensurePathExists(file));
                        }
                        TaskData lastReadData = state != null ? state.getLastReadData() : null;
                        TaskDataDiff diff = TaskDataManager.this.synchronizationManager.createDiff(taskData, lastReadData, monitor);
                        suppressIncoming = Boolean.toString(!diff.hasChanged());
                        switch (task.getSynchronizationState()) {
                            case OUTGOING: {
                                task.setSynchronizationState(ITask.SynchronizationState.CONFLICT);
                                break;
                            }
                            case SYNCHRONIZED: {
                                task.setSynchronizationState(ITask.SynchronizationState.INCOMING);
                            }
                        }
                        task.setAttribute("task.common.suppress.incoming", suppressIncoming);
                    }
                    if (task.isSynchronizing()) {
                        task.setSynchronizing(false);
                        synchronizationStateChanged[0] = true;
                    }
                }
            });
        } else {
            this.taskList.run(new ITaskListRunnable(){

                @Override
                public void execute(IProgressMonitor monitor) throws CoreException {
                    if (task.isSynchronizing()) {
                        task.setSynchronizing(false);
                        synchronizationStateChanged[0] = true;
                    }
                }
            });
        }
        if (event.getTaskChanged() || event.getTaskDataChanged()) {
            this.taskList.notifyElementChanged(task);
            this.fireTaskDataUpdated(event);
        } else {
            if (synchronizationStateChanged[0]) {
                this.taskList.notifySynchronizationStateChanged(task);
            }
            if (event.getTaskDataUpdated()) {
                this.fireTaskDataUpdated(event);
            }
        }
    }

    private boolean updateTaskFromTaskData(TaskData taskData, AbstractTask task, AbstractRepositoryConnector connector, TaskRepository repository) {
        task.setChanged(false);
        Date oldDueDate = task.getDueDate();
        connector.updateTaskFromTaskData(repository, task, taskData);
        Date newDueDate = task.getDueDate();
        if (oldDueDate != null && !oldDueDate.equals(newDueDate) || newDueDate != oldDueDate) {
            this.taskActivityManager.setDueDate(task, newDueDate);
        }
        return task.isChanged();
    }

    private File ensurePathExists(File file) {
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        return file;
    }

    private File getMigratedFile(ITask task, String kind) throws CoreException {
        File oldFile;
        Assert.isNotNull((Object)task);
        Assert.isNotNull((Object)kind);
        File file = this.fileManager.getFile(task, kind);
        if (!file.exists() && (oldFile = this.fileManager.getFile10(task, kind)).exists()) {
            TaskDataState state = this.taskDataStore.getTaskDataState(oldFile);
            this.taskDataStore.putTaskData(this.ensurePathExists(file), state);
        }
        return file;
    }

    @Override
    public void discardEdits(ITask itask) throws CoreException {
        final AbstractTask task = (AbstractTask)itask;
        Assert.isNotNull((Object)task);
        final String kind = task.getConnectorKind();
        final TaskDataManagerEvent event = new TaskDataManagerEvent(this, itask);
        this.taskList.run(new ITaskListRunnable(){

            @Override
            public void execute(IProgressMonitor monitor) throws CoreException {
                File dataFile = TaskDataManager.this.fileManager.getFile(task, kind);
                if (dataFile.exists()) {
                    TaskDataManager.this.taskDataStore.discardEdits(dataFile);
                }
                switch (task.getSynchronizationState()) {
                    case OUTGOING: {
                        task.setSynchronizationState(ITask.SynchronizationState.SYNCHRONIZED);
                        event.setTaskChanged(true);
                        break;
                    }
                    case CONFLICT: {
                        task.setSynchronizationState(ITask.SynchronizationState.INCOMING);
                        event.setTaskChanged(true);
                    }
                }
            }
        });
        if (event.getTaskChanged()) {
            this.taskList.notifyElementChanged(task);
        }
        this.fireEditsDiscarded(event);
    }

    private File findFile(ITask task, String kind) {
        File file = this.fileManager.getFile(task, kind);
        if (file.exists()) {
            return file;
        }
        return this.fileManager.getFile10(task, kind);
    }

    public String getDataPath() {
        return this.fileManager.getDataPath();
    }

    @Override
    public TaskData getTaskData(ITask task) throws CoreException {
        Assert.isNotNull((Object)task);
        String kind = task.getConnectorKind();
        TaskDataState state = this.taskDataStore.getTaskDataState(this.findFile(task, kind));
        if (state == null) {
            return null;
        }
        return state.getRepositoryData();
    }

    public TaskDataState getTaskDataState(ITask task) throws CoreException {
        Assert.isNotNull((Object)task);
        String kind = task.getConnectorKind();
        return this.taskDataStore.getTaskDataState(this.findFile(task, kind));
    }

    @Override
    public TaskData getTaskData(TaskRepository taskRepository, String taskId) throws CoreException {
        Assert.isNotNull((Object)((Object)taskRepository));
        Assert.isNotNull((Object)taskId);
        TaskDataState state = this.taskDataStore.getTaskDataState(this.findFile(new TaskTask(taskRepository.getConnectorKind(), taskRepository.getRepositoryUrl(), taskId), taskRepository.getConnectorKind()));
        if (state == null) {
            return null;
        }
        return state.getRepositoryData();
    }

    @Override
    public boolean hasTaskData(ITask task) {
        Assert.isNotNull((Object)task);
        String kind = task.getConnectorKind();
        return this.findFile(task, kind).exists();
    }

    public void putSubmittedTaskData(ITask itask, final TaskData taskData, IDelegatingProgressMonitor monitor) throws CoreException {
        final AbstractTask task = (AbstractTask)itask;
        Assert.isNotNull((Object)task);
        Assert.isNotNull((Object)taskData);
        final AbstractRepositoryConnector connector = this.repositoryManager.getRepositoryConnector(task.getConnectorKind());
        final TaskRepository repository = this.repositoryManager.getRepository(task.getConnectorKind(), task.getRepositoryUrl());
        final TaskDataManagerEvent event = new TaskDataManagerEvent(this, itask, taskData, null);
        event.setTaskDataChanged(true);
        event.setData(((DelegatingProgressMonitor)monitor).getData());
        this.taskList.run(new ITaskListRunnable(){

            @Override
            public void execute(IProgressMonitor monitor) throws CoreException {
                if (!taskData.isPartial()) {
                    File file = TaskDataManager.this.getMigratedFile(task, task.getConnectorKind());
                    TaskDataManager.this.taskDataStore.setTaskData(TaskDataManager.this.ensurePathExists(file), taskData);
                    task.setMarkReadPending(false);
                    event.setTaskDataUpdated(true);
                }
                boolean taskChanged = TaskDataManager.this.updateTaskFromTaskData(taskData, task, connector, repository);
                event.setTaskChanged(taskChanged);
                task.setSynchronizationState(ITask.SynchronizationState.SYNCHRONIZED);
                task.setSynchronizing(false);
            }
        });
        this.taskList.notifyElementChanged(task);
        this.fireTaskDataUpdated(event);
    }

    public void deleteTaskData(ITask itask) throws CoreException {
        Assert.isTrue((boolean)(itask instanceof AbstractTask));
        final AbstractTask task = (AbstractTask)itask;
        this.taskList.run(new ITaskListRunnable(){

            @Override
            public void execute(IProgressMonitor monitor) throws CoreException {
                File file = TaskDataManager.this.fileManager.getFile(task, task.getConnectorKind());
                if (file.exists()) {
                    TaskDataManager.this.taskDataStore.deleteTaskData(file);
                    task.setSynchronizationState(ITask.SynchronizationState.SYNCHRONIZED);
                }
            }
        });
        this.taskList.notifyElementChanged(task);
    }

    public void setDataPath(String dataPath) {
        this.fileManager.setDataPath(dataPath);
    }

    public boolean setTaskRead(ITask itask, final boolean read) {
        final AbstractTask task = (AbstractTask)itask;
        Assert.isNotNull((Object)task);
        final boolean[] changed = new boolean[1];
        try {
            this.taskList.run(new ITaskListRunnable(){

                @Override
                public void execute(IProgressMonitor monitor) throws CoreException {
                    if (read) {
                        switch (task.getSynchronizationState()) {
                            case INCOMING: 
                            case INCOMING_NEW: {
                                task.setSynchronizationState(ITask.SynchronizationState.SYNCHRONIZED);
                                task.setMarkReadPending(true);
                                changed[0] = true;
                                break;
                            }
                            case CONFLICT: {
                                task.setSynchronizationState(ITask.SynchronizationState.OUTGOING);
                                task.setMarkReadPending(true);
                                changed[0] = true;
                            }
                        }
                    } else {
                        task.setAttribute("task.common.suppress.incoming", Boolean.toString(false));
                        switch (task.getSynchronizationState()) {
                            case SYNCHRONIZED: {
                                task.setSynchronizationState(ITask.SynchronizationState.INCOMING);
                                task.setMarkReadPending(false);
                                changed[0] = true;
                            }
                        }
                    }
                }
            });
        }
        catch (CoreException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.tasks.core", "Unexpected error while marking task read", (Throwable)e));
        }
        if (changed[0]) {
            this.taskList.notifyElementChanged(task);
        }
        return changed[0];
    }

    void putEdits(ITask itask, final TaskData editsData) throws CoreException {
        final AbstractTask task = (AbstractTask)itask;
        Assert.isNotNull((Object)task);
        final String kind = task.getConnectorKind();
        Assert.isNotNull((Object)editsData);
        final boolean[] changed = new boolean[1];
        this.taskList.run(new ITaskListRunnable(){

            @Override
            public void execute(IProgressMonitor monitor) throws CoreException {
                TaskDataManager.this.taskDataStore.putEdits(TaskDataManager.this.fileManager.getFile(task, kind), editsData);
                switch (task.getSynchronizationState()) {
                    case INCOMING: 
                    case INCOMING_NEW: {
                        task.setSynchronizationState(ITask.SynchronizationState.CONFLICT);
                        changed[0] = true;
                        break;
                    }
                    case SYNCHRONIZED: {
                        task.setSynchronizationState(ITask.SynchronizationState.OUTGOING);
                        changed[0] = true;
                    }
                }
            }
        });
        if (changed[0]) {
            this.taskList.notifySynchronizationStateChanged(task);
        }
    }

    private void fireTaskDataUpdated(final TaskDataManagerEvent event) {
        ITaskDataManagerListener[] array = this.listeners.toArray(new ITaskDataManagerListener[0]);
        if (array.length > 0) {
            ITaskDataManagerListener[] iTaskDataManagerListenerArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                final ITaskDataManagerListener listener = iTaskDataManagerListenerArray[n2];
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                    }

                    public void run() throws Exception {
                        listener.taskDataUpdated(event);
                    }
                });
                ++n2;
            }
        }
    }

    private void fireEditsDiscarded(final TaskDataManagerEvent event) {
        ITaskDataManagerListener[] array = this.listeners.toArray(new ITaskDataManagerListener[0]);
        if (array.length > 0) {
            ITaskDataManagerListener[] iTaskDataManagerListenerArray = array;
            int n = array.length;
            int n2 = 0;
            while (n2 < n) {
                final ITaskDataManagerListener listener = iTaskDataManagerListenerArray[n2];
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                    }

                    public void run() throws Exception {
                        listener.editsDiscarded(event);
                    }
                });
                ++n2;
            }
        }
    }

    public void refactorRepositoryUrl(ITask itask, final String newStorageRepositoryUrl, final String newRepositoryUrl) throws CoreException {
        Assert.isTrue((boolean)(itask instanceof AbstractTask));
        final AbstractTask task = (AbstractTask)itask;
        final String kind = task.getConnectorKind();
        this.taskList.run(new ITaskListRunnable(){

            @Override
            public void execute(IProgressMonitor monitor) throws CoreException {
                TaskDataState oldState;
                File file = TaskDataManager.this.getMigratedFile(task, kind);
                if (file.exists() && (oldState = TaskDataManager.this.taskDataStore.getTaskDataState(file)) != null) {
                    File newFile = TaskDataManager.this.fileManager.getFile(newStorageRepositoryUrl, task, kind);
                    TaskDataState newState = new TaskDataState(oldState.getConnectorKind(), newRepositoryUrl, oldState.getTaskId());
                    newState.merge(oldState);
                    TaskDataManager.this.taskDataStore.putTaskData(TaskDataManager.this.ensurePathExists(newFile), newState);
                }
            }
        });
    }

    public void refactorAttributeValue(ITask itask, final Map<TaskAttribute, Collection<String>> newValues) throws CoreException {
        Assert.isTrue((boolean)(itask instanceof AbstractTask));
        final AbstractTask task = (AbstractTask)itask;
        final String kind = task.getConnectorKind();
        this.taskList.run(new ITaskListRunnable(){

            @Override
            public void execute(IProgressMonitor monitor) throws CoreException {
                TaskDataState state;
                File file = TaskDataManager.this.getMigratedFile(task, kind);
                if (file.exists() && (state = TaskDataManager.this.taskDataStore.getTaskDataState(file)) != null) {
                    state.changeAttributeValues(newValues);
                    TaskDataManager.this.taskDataStore.putTaskData(file, state);
                }
            }
        });
    }

    public void refactorTaskId(final AbstractTask task, final ITask newTask) throws CoreException {
        final String kind = task.getConnectorKind();
        this.taskList.run(new ITaskListRunnable(){

            @Override
            public void execute(IProgressMonitor monitor) throws CoreException {
                TaskDataState oldState;
                File file = TaskDataManager.this.getMigratedFile(task, kind);
                if (file.exists() && (oldState = TaskDataManager.this.taskDataStore.getTaskDataState(file)) != null) {
                    File newFile = TaskDataManager.this.fileManager.getFile(task.getRepositoryUrl(), newTask, kind);
                    TaskDataState newState = new TaskDataState(oldState.getConnectorKind(), task.getRepositoryUrl(), newTask.getTaskId());
                    newState.merge(oldState);
                    TaskDataManager.this.taskDataStore.putTaskData(TaskDataManager.this.ensurePathExists(newFile), newState);
                    TaskDataManager.this.taskDataStore.deleteTaskData(file);
                }
            }
        });
    }

    public void refactorAttribute(ITask itask, final TaskAttribute attribute) throws CoreException {
        Assert.isTrue((boolean)(itask instanceof AbstractTask));
        final AbstractTask task = (AbstractTask)itask;
        final String kind = task.getConnectorKind();
        this.taskList.run(new ITaskListRunnable(){

            @Override
            public void execute(IProgressMonitor monitor) throws CoreException {
                TaskDataState state;
                File file = TaskDataManager.this.getMigratedFile(task, kind);
                if (file.exists() && (state = TaskDataManager.this.taskDataStore.getTaskDataState(file)) != null) {
                    state.refactorAttribute(attribute);
                    TaskDataManager.this.taskDataStore.putTaskData(file, state);
                }
            }
        });
    }
}

