/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks;

import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.m2m.internal.qvt.oml.ast.binding.ASTBindingHelper;
import org.eclipse.m2m.internal.qvt.oml.ast.binding.IModuleSourceInfo;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParserUtil;
import org.eclipse.m2m.internal.qvt.oml.compiler.BlackboxUnitResolver;
import org.eclipse.m2m.internal.qvt.oml.cst.InstantiationExpCS;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingDeclarationCS;
import org.eclipse.m2m.internal.qvt.oml.cst.MappingMethodCS;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.CSTHelper;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks.HyperlinkUtil;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks.IHyperlinkDetectorHelper;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks.MetamodelElementHyperlink;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.hyperlinks.QvtFileHyperlink;
import org.eclipse.m2m.internal.qvt.oml.expressions.Constructor;
import org.eclipse.m2m.internal.qvt.oml.expressions.ImperativeOperation;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.qvt.oml.ecore.ImperativeOCL.InstantiationExp;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.cst.OperationCallExpCS;
import org.eclipse.ocl.cst.SimpleNameCS;
import org.eclipse.ocl.cst.TypeCS;
import org.eclipse.ocl.ecore.OperationCallExp;
import org.eclipse.ocl.utilities.ASTNode;

public class OperationHyperlinkDetector
implements IHyperlinkDetectorHelper {
    @Override
    public IHyperlink detectHyperlink(IHyperlinkDetectorHelper.IDetectionContext context) {
        SimpleNameCS nameCS;
        EOperation operation;
        CSTNode syntaxElement = context.getSyntaxElement();
        if (syntaxElement instanceof InstantiationExpCS) {
            if (!(syntaxElement.getAst() instanceof InstantiationExp)) {
                return null;
            }
            InstantiationExp instExp = (InstantiationExp)syntaxElement.getAst();
            Constructor constructor = ASTBindingHelper.getConstructorOperation((InstantiationExp)instExp);
            if (constructor == null) {
                return null;
            }
            CSTNode resultCS = ASTBindingHelper.resolveCSTNode((ASTNode)constructor);
            InstantiationExpCS nameCS2 = (InstantiationExpCS)syntaxElement;
            if (resultCS instanceof MappingMethodCS) {
                MappingMethodCS methodCS = (MappingMethodCS)resultCS;
                IRegion destRegion = this.getGoToOperationRegion(methodCS);
                URI sourceURI = ASTBindingHelper.resolveModuleFile((EObject)CSTHelper.getModule((CSTNode)methodCS));
                return new QvtFileHyperlink(HyperlinkUtil.createRegion((CSTNode)nameCS2), sourceURI, destRegion, destRegion);
            }
            return new MetamodelElementHyperlink(HyperlinkUtil.createRegion((CSTNode)nameCS2), (EModelElement)constructor);
        }
        if (syntaxElement instanceof SimpleNameCS && (operation = OperationHyperlinkDetector.resolveOperationDecl(nameCS = (SimpleNameCS)syntaxElement)) != null) {
            IModuleSourceInfo moduleSourceBinding;
            Module owningModule = QvtOperationalParserUtil.getOwningModule((EOperation)operation);
            MappingMethodCS methodCS = OperationHyperlinkDetector.resolveImperativeOperationDecl(nameCS);
            if (methodCS != null) {
                IRegion destRegion = this.getGoToOperationRegion(methodCS);
                URI sourceURI = ASTBindingHelper.resolveModuleFile((EObject)CSTHelper.getModule((CSTNode)methodCS));
                return new QvtFileHyperlink(HyperlinkUtil.createRegion((CSTNode)nameCS), sourceURI, destRegion, destRegion);
            }
            if (owningModule != null && (moduleSourceBinding = ASTBindingHelper.getModuleSourceBinding((Module)owningModule)) != null && BlackboxUnitResolver.isBlackboxUnitURI((URI)moduleSourceBinding.getSourceURI())) {
                return new QvtFileHyperlink(HyperlinkUtil.createRegion((CSTNode)nameCS), moduleSourceBinding.getSourceURI(), operation.getName());
            }
            return new MetamodelElementHyperlink(HyperlinkUtil.createRegion((CSTNode)nameCS), (EModelElement)operation);
        }
        return null;
    }

    public static EOperation resolveOperationDecl(SimpleNameCS nameCS) {
        OperationCallExpCS featureCallExpCS;
        ASTNode featureASTNode;
        if (nameCS.eContainer() instanceof OperationCallExpCS && (featureASTNode = ASTBindingHelper.resolveASTNode((CSTNode)(featureCallExpCS = (OperationCallExpCS)nameCS.eContainer()))) instanceof OperationCallExp) {
            OperationCallExp operationCallExp = (OperationCallExp)featureASTNode;
            return (EOperation)operationCallExp.getReferredOperation();
        }
        return null;
    }

    public static MappingMethodCS resolveImperativeOperationDecl(SimpleNameCS nameCS) {
        EOperation operation = OperationHyperlinkDetector.resolveOperationDecl(nameCS);
        if (operation instanceof ImperativeOperation) {
            CSTNode resultCS = ASTBindingHelper.resolveCSTNode((ASTNode)((ImperativeOperation)operation));
            return resultCS instanceof MappingMethodCS ? (MappingMethodCS)resultCS : null;
        }
        return null;
    }

    private IRegion getGoToOperationRegion(MappingMethodCS mappingMethodCS) {
        int startOffset = mappingMethodCS.getStartOffset();
        int length = 0;
        MappingDeclarationCS decl = mappingMethodCS.getMappingDeclarationCS();
        if (decl != null) {
            SimpleNameCS simpleName = decl.getSimpleNameCS();
            length = simpleName != null ? simpleName.getValue().length() : length;
            TypeCS context = decl.getContextType();
            if (context != null) {
                startOffset = mappingMethodCS.getMappingDeclarationCS().getContextType().getEndOffset();
                startOffset += 3;
            } else {
                startOffset = simpleName.getStartOffset();
            }
        }
        return new Region(startOffset, length);
    }
}

