/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.wsdl.ui.internal.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.Import;
import org.eclipse.wst.wsdl.Types;
import org.eclipse.wst.wsdl.XSDSchemaExtensibilityElement;
import org.eclipse.wst.wsdl.ui.internal.extensions.ITypeSystemProvider;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaContent;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.impl.XSDImportImpl;
import org.eclipse.xsd.impl.XSDSchemaImpl;

public class XSDTypeSystemProvider
implements ITypeSystemProvider {
    public List getPrefixes(Definition definition, String namespace) {
        ArrayList<String> list = new ArrayList<String>();
        Map map = definition.getNamespaces();
        for (String prefix : map.keySet()) {
            String theNamespace = (String)map.get(prefix);
            if (theNamespace == null || !theNamespace.equals(namespace)) continue;
            list.add(prefix);
        }
        return list;
    }

    @Override
    public List getPrefixedNames(Definition definition, String namespace, String localName) {
        ArrayList<String> list = new ArrayList<String>();
        for (String prefix : this.getPrefixes(definition, namespace)) {
            String name = prefix != null && prefix.length() > 0 ? String.valueOf(prefix) + ":" + localName : localName;
            list.add(name);
        }
        return list;
    }

    protected void addNamedComponents(Definition definition, List list, List namedComponents) {
        for (XSDNamedComponent component : namedComponents) {
            list.addAll(this.getPrefixedNames(definition, component.getTargetNamespace(), component.getName()));
        }
    }

    public void initWSIStyleImports(XSDSchema xsdSchema) {
        if (xsdSchema.getTargetNamespace() == null) {
            for (XSDSchemaContent content : xsdSchema.getContents()) {
                XSDImportImpl xsdImport;
                XSDSchema schema;
                if (!(content instanceof XSDImportImpl) || (schema = (xsdImport = (XSDImportImpl)content).getResolvedSchema()) != null) continue;
                schema = xsdImport.importSchema();
            }
        }
    }

    @Override
    public List getAvailableTypeNames(Definition definition, int typeNameCategory) {
        List list = new ArrayList();
        if (typeNameCategory == 1) {
            list = this.getBuiltInTypeNamesList(definition);
        } else {
            XSDSchema schema;
            Types types = definition.getETypes();
            if (types != null) {
                for (Object o : types.getEExtensibilityElements()) {
                    if (!(o instanceof XSDSchemaExtensibilityElement) || (schema = ((XSDSchemaExtensibilityElement)o).getSchema()) == null) continue;
                    this.initWSIStyleImports(schema);
                    this.addNamedComponents(definition, list, (List)schema.getTypeDefinitions());
                }
            }
            for (Import theImport : definition.getEImports()) {
                schema = theImport.getESchema();
                if (schema == null) continue;
                this.addNamedComponents(definition, list, (List)schema.getTypeDefinitions());
            }
            list.addAll(this.getBuiltInTypeNamesList(definition));
        }
        return list;
    }

    @Override
    public List getAvailableTypes(Definition definition, XSDSchema schema, int typeNameCategory) {
        ArrayList keepTypes;
        block3: {
            Iterator typeIterator;
            block2: {
                keepTypes = new ArrayList();
                typeIterator = schema.getTypeDefinitions().iterator();
                if (typeNameCategory != 4) break block2;
                while (typeIterator.hasNext()) {
                    Object type = typeIterator.next();
                    if (!(type instanceof XSDComplexTypeDefinition)) continue;
                    keepTypes.add(type);
                }
                break block3;
            }
            if (typeNameCategory != 2) break block3;
            while (typeIterator.hasNext()) {
                Object type = typeIterator.next();
                if (!(type instanceof XSDSimpleTypeDefinition)) continue;
                keepTypes.add(type);
            }
        }
        return keepTypes;
    }

    public List getBuiltInTypeNamesList(Definition definition) {
        if (definition == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<String> builtInTypeNames = new ArrayList<String>();
        XSDSchema schemaForSchema = XSDSchemaImpl.getSchemaForSchema((String)"http://www.w3.org/2001/XMLSchema");
        Map simpleTypeIdMap = schemaForSchema.getSimpleTypeIdMap();
        Collection builtInTypes = simpleTypeIdMap.values();
        Iterator iterator = builtInTypes.iterator();
        String xsdPrefix = definition.getPrefix("http://www.w3.org/2001/XMLSchema");
        while (iterator.hasNext()) {
            XSDTypeDefinition typeDefinition = (XSDTypeDefinition)iterator.next();
            String localName = typeDefinition.getName();
            String prefixedName = xsdPrefix != null && xsdPrefix.length() > 0 ? String.valueOf(xsdPrefix) + ":" + localName : localName;
            builtInTypeNames.add(prefixedName);
        }
        return builtInTypeNames;
    }

    @Override
    public List getAvailableElementNames(Definition definition) {
        XSDSchema schema;
        ArrayList list = new ArrayList();
        Types types = definition.getETypes();
        if (types != null) {
            for (Object o : types.getEExtensibilityElements()) {
                if (!(o instanceof XSDSchemaExtensibilityElement) || (schema = ((XSDSchemaExtensibilityElement)o).getSchema()) == null) continue;
                this.initWSIStyleImports(schema);
                this.addNamedComponents(definition, list, (List)schema.getElementDeclarations());
            }
        }
        for (Import theImport : definition.getEImports()) {
            schema = theImport.getESchema();
            if (schema == null) continue;
            this.addNamedComponents(definition, list, (List)schema.getElementDeclarations());
        }
        return list;
    }

    @Override
    public int getCategoryForTypeName(Definition definition, String typeName) {
        return 0;
    }
}

