/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.browse.classpath;

import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.ImageInfo;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.pages.browse.model.IImageResource;

final class SrcImageResource
implements IImageResource {
    private final String m_id;
    private final IPackageFragmentRoot m_packageFragmentRoot;
    private final IFile m_file;
    private ImageInfo m_imageInfo;

    public SrcImageResource(String id, IPackageFragmentRoot packageFragmentRoot, IFile file) {
        this.m_id = id;
        this.m_packageFragmentRoot = packageFragmentRoot;
        this.m_file = file;
    }

    public Image getImage() {
        ImageInfo imageInfo = this.getImageInfo();
        return imageInfo != null ? imageInfo.getImage() : null;
    }

    public String getName() {
        return this.m_file.getFullPath().lastSegment();
    }

    public ImageInfo getImageInfo() {
        if (this.m_imageInfo == null) {
            Image image;
            int srcSegments = this.m_packageFragmentRoot.getResource().getFullPath().segmentCount();
            String path = this.m_file.getFullPath().removeFirstSegments(srcSegments).toOSString();
            path = path.replace('\\', '/');
            try {
                InputStream inputStream = this.m_file.getContents();
                try {
                    image = new Image((Device)Display.getCurrent(), inputStream);
                }
                finally {
                    inputStream.close();
                }
            }
            catch (Throwable e) {
                return null;
            }
            try {
                this.m_imageInfo = new ImageInfo(this.m_id, path, image, -1L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return this.m_imageInfo;
    }

    void dispose() {
        if (this.m_imageInfo != null) {
            this.m_imageInfo.getImage().dispose();
        }
    }
}

