/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.transformation.runtime.emf.filters;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.transformation.evm.api.event.EventFilter;

public class MatchParameterFilter
implements EventFilter<IPatternMatch> {
    private Map<String, Object> filterMap;

    public MatchParameterFilter(String name, Object parameter) {
        this.filterMap = new HashMap<String, Object>();
        this.filterMap.put(name, parameter);
    }

    public MatchParameterFilter(Map<String, Object> filterMap) {
        this.filterMap = new HashMap<String, Object>();
        this.filterMap.putAll(filterMap);
    }

    @SafeVarargs
    public MatchParameterFilter(Map.Entry<String, ?> ... parameters) {
        this.filterMap = Arrays.stream(parameters).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public boolean isProcessable(IPatternMatch eventAtom) {
        return eventAtom.parameterNames().stream().noneMatch(it -> this.filterMap.containsKey(it) && !Objects.equals(this.filterMap.get(it), eventAtom.get(it)));
    }

    public <Match extends IPatternMatch, Matcher extends ViatraQueryMatcher<Match>> Match toMatch(Matcher matcher) {
        IPatternMatch match = matcher.newEmptyMatch();
        matcher.getParameterNames().stream().filter(this.filterMap::containsKey).forEach(name -> {
            boolean bl = match.set(name, this.filterMap.get(name));
        });
        return (Match)match;
    }
}

