/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.nattable.handler;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.SetValueCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.infra.nattable.handler.AbstractMergeHandler;
import org.eclipse.papyrus.infra.nattable.model.nattable.NattablePackage;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AbstractHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TableHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.BooleanValueStyle;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NattablestyleFactory;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattablestyle.NattablestylePackage;
import org.eclipse.papyrus.infra.nattable.utils.HeaderAxisConfigurationManagementUtils;
import org.eclipse.papyrus.infra.services.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.infra.services.edit.service.IElementEditService;
import org.eclipse.ui.handlers.HandlerUtil;

public class MergeRowsHandler
extends AbstractMergeHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        CompositeCommand mergeCommand = new CompositeCommand("Merge/UnMerge the cells in all the rows");
        TransactionalEditingDomain tableDomain = this.getTableEditingDomain();
        String commandId = event.getCommand().getId();
        boolean isMerged = HandlerUtil.toggleCommandState((Command)event.getCommand());
        AbstractHeaderAxisConfiguration rowHeaderUsedInTable = HeaderAxisConfigurationManagementUtils.getRowAbstractHeaderAxisConfigurationUsedInTable(this.getTable());
        BooleanValueStyle mergeRows = (BooleanValueStyle)rowHeaderUsedInTable.getNamedStyle(NattablestylePackage.eINSTANCE.getBooleanValueStyle(), "mergeRows");
        if (mergeRows != null) {
            if (mergeRows.isBooleanValue()) {
                SetRequest mergeRowRequest = new SetRequest(tableDomain, (EObject)mergeRows, (EStructuralFeature)NattablestylePackage.eINSTANCE.getBooleanValueStyle_BooleanValue(), (Object)false);
                SetValueCommand mergeRowCommand = new SetValueCommand(mergeRowRequest);
                mergeCommand.add((IUndoableOperation)mergeRowCommand);
            } else {
                SetRequest mergeRowRequest = new SetRequest(tableDomain, (EObject)mergeRows, (EStructuralFeature)NattablestylePackage.eINSTANCE.getBooleanValueStyle_BooleanValue(), (Object)true);
                SetValueCommand mergeRowCommand = new SetValueCommand(mergeRowRequest);
                mergeCommand.add((IUndoableOperation)mergeRowCommand);
            }
        } else {
            if (rowHeaderUsedInTable instanceof TableHeaderAxisConfiguration) {
                rowHeaderUsedInTable = HeaderAxisConfigurationManagementUtils.transformToLocalHeaderConfiguration((TableHeaderAxisConfiguration)rowHeaderUsedInTable);
                EReference localHeaderFeature = NattablePackage.eINSTANCE.getTable_LocalRowHeaderAxisConfiguration();
                SetRequest initLocalRowHeaderAxis = new SetRequest(tableDomain, (EObject)this.getTable(), (EStructuralFeature)localHeaderFeature, (Object)rowHeaderUsedInTable);
                IElementEditService localRowHeaderAxisProvider = ElementEditServiceUtils.getCommandProvider((EObject)this.getTable());
                mergeCommand.add((IUndoableOperation)localRowHeaderAxisProvider.getEditCommand((IEditCommandRequest)initLocalRowHeaderAxis));
            }
            mergeRows = NattablestyleFactory.eINSTANCE.createBooleanValueStyle();
            mergeRows.setBooleanValue(true);
            mergeRows.setName("mergeRows");
            SetRequest mergeRowRequest = new SetRequest(tableDomain, (EObject)rowHeaderUsedInTable, (EStructuralFeature)NattablestylePackage.eINSTANCE.getStyledElement_Styles(), (Object)mergeRows);
            SetValueCommand mergeRowCommand = new SetValueCommand(mergeRowRequest);
            mergeCommand.add((IUndoableOperation)mergeRowCommand);
        }
        if (!isMerged) {
            this.updateTableSpanBooleans(commandId, mergeCommand);
        }
        this.executeMergeCommands(mergeCommand, tableDomain);
        return null;
    }
}

